import { TranslateService } from '@ngx-translate/core';
import { Role } from '../../models/role.model';
import { AbstractRolesScopesService } from './abstract-roles-scopes.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class RolesScopesService extends AbstractRolesScopesService {
    /**
     * constructor
     */
    constructor(translateService: TranslateService);
    /**
     * Get all Roles Async
     *
     * @returns Roles array promisse
     */
    getAllRolesAsync(): Promise<Role[]>;
    /**
     * create role Async
     *
     * @param roleName
     * @returns Boolean promise, true when successful
     */
    createRoleAsync(newRole: Role): Promise<Role>;
    /**
     * update role
     *
     * @param role role with new data
     * @returns booler promise, true when successful
     */
    updateRole(role: Role): Promise<Role>;
    static ɵfac: i0.ɵɵFactoryDeclaration<RolesScopesService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<RolesScopesService>;
}
