import { TranslateService } from '@ngx-translate/core';
import { Role } from '../../models/role.model';
/**
 * AbstractRolesScopesService class that defines an
 * <br />abstract roles and scopes service to
 * <br />be extended by the mock and real
 * <br />roles and scopes services
 */
export declare abstract class AbstractRolesScopesService {
    private translationService;
    /**
     * constructor
     * @param translationService
     */
    constructor(translationService: TranslateService);
    /**
     * Get all Roles
     */
    abstract getAllRolesAsync(): Promise<Role[]>;
    /**
     * Create Role Async
     *
     * @param {string} roleName  The new Role name
     *
     * @Returns boolean
     */
    abstract createRoleAsync(role: Role): Promise<Role>;
    /**
     * Update Scope
     *
     * @param role
     *
     * @Returns boolean
     */
    abstract updateRole(role: Role): Promise<Role>;
    protected getTranslationsAsync(roles: Role[] | Role): Promise<Role[] | Role>;
}
