import { TranslateService } from '@ngx-translate/core';
import { IsLoadingDataService } from '../../../../core/services/is-loading-data/isloadingdata.service';
import { NotificationsService } from '../../../../core/services/notifications/notifications.service';
import { UtilityService } from '../../../../core/services/utility/utility.service';
import { Role } from '../../../models/role.model';
import { AbstractRolesScopesService } from '../../../services/roles-scopes/abstract-roles-scopes.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class MockRolesScopesService extends AbstractRolesScopesService {
    private notificationsService;
    private utilityService;
    private isLoadingDataService;
    /**
     * default time in seconds
     */
    private sleepTimeSec;
    /**
     * constructor
     */
    constructor(notificationsService: NotificationsService, utilityService: UtilityService, isLoadingDataService: IsLoadingDataService, translateService: TranslateService);
    /**
     * Get all Roles Async
     *
     * @returns Roles array promisse
     */
    getAllRolesAsync(): Promise<Role[]>;
    /**
     * create role Async
     *
     * @param roleName
     * @returns Boolean promise, true when successful
     */
    createRoleAsync(role: Role): Promise<Role>;
    /**
     * update role
     *
     * @param role role with new data
     * @returns booler promise, true when successful
     */
    updateRole(role: Role): Promise<Role>;
    static ɵfac: i0.ɵɵFactoryDeclaration<MockRolesScopesService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<MockRolesScopesService>;
}
