import { OnInit } from '@angular/core';
import { TreeNode } from 'primeng/api';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { AbstractEntityTypeService } from '../../../entity-types/services/entity-types/abstract-entity-type.service';
import { PrgRolesScopesConfig } from '../../models/prg-roles-scopes-config';
import { Role } from '../../models/role.model';
import { AbstractRolesScopesService } from '../../services/roles-scopes/abstract-roles-scopes.service';
import { PrgScopesNode } from './models/prg-scopes-node';
import * as i0 from "@angular/core";
/**
 * Scopes table component
 * Tri checkbox legend:
 * true-> all selected
 * false-> partial selected
 * null-> non selected
 */
export declare class PrgScopesTableComponent implements OnInit {
    private objectsUtilityService;
    private arrayUtilityService;
    private rolesScopesService;
    private abstractEntityTypeService;
    prgRolesScopesConfig: PrgRolesScopesConfig;
    /**
     * has a role selected
     */
    haveRole: boolean;
    /**
     * Role aux
     */
    private _role;
    /**
     * Role that we want to configure
     */
    set role(value: Role);
    /**
     * treeData
     */
    treeData: TreeNode<PrgScopesNode>[];
    /**
     * table columns
     */
    tableColumns: string[];
    /**
     * haveChangesToSave
     */
    haveChangesToSave: boolean;
    /**
     * Entity types
     */
    private entityTypes;
    /**
     * base scopes
     */
    private baseScopes;
    /**
     * constructor
     * @param objectsUtilityService
     * @param arrayUtilityService
     * @param rolesScopesService
     * @param prgRolesScopesConfig  prgRolesScopesConfig
     */
    constructor(objectsUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, rolesScopesService: AbstractRolesScopesService, abstractEntityTypeService: AbstractEntityTypeService, prgRolesScopesConfig: PrgRolesScopesConfig);
    /**
     * ngOnInit
     *
     * set value to
     * [treeData]{@link #treeData}
     * [entityTypes]{@link #entityTypes}
     * [tableColumns]{@link #tableColumns}
     *
     * call method [getAllEntityType]{@link /classes/AbstractRolesScopesService.html#getAllEntityType} from services
     */
    ngOnInit(): void;
    /**
     * this function receives the scopes and arranges
     * them by group into the correct structure
     * to be used in the treetable
     *
     * this function call [createEntityTypeColumns]{@link #createEntityTypeColumns} to create entity type columns
     * this function call [createGroupColumns]{@link #createGroupColumns} to create columns
     *
     * @returns TreeNode<PrgScopesNode>[]
     */
    private createDataStructure;
    /**
     * this function create Entity Columns
     * @param entityType
     * @returns PrgScopesColumns
     */
    private createEntityTypeColumns;
    /**
     * this function create group columns
     * @param nodes
     * @returns PrgScopesColumns
     */
    private createGroupColumns;
    /**
     * this function returns an array with all scopes
     *
     * @returns PrgScopeColumnData[]
     */
    private getScopeObjectsFromTree;
    /**
     * is an auxiliary function, which makes use of
     * recursion to return all the scopes of
     * all the children of the tree
     *
     * @param prev
     * @param items
     * @returns PrgScopeColumnData[]
     */
    private getScopeObjectsFromTreeChildrens;
    /**
     * This function is responsible for checking all scopes received as parameters
     *
     * this function call [getScopeObjectsFromTree]{@link #getScopeObjectsFromTree} to get all scopes
     *
     * @param scopes
     */
    private setSelectedScopes;
    /**
     * this function maps the scopes of the selected role in the table data
     *
     *
     * @param roleScopes
     * @returns
     */
    private mappingTheScopesOfARole;
    /**
     * this function is responsible for checking or unchecking
     * all the other scopes of a row, making all
     * the necessary checks to validate the state
     * of the group, column and row
     *
     * @param event
     * @param groupName
     * @param rowData
     */
    otherCheckedChange(event: any, groupName: string, rowData: PrgScopesNode): void;
    /**
     * toogle column in group
     *
     * @param rowData
     * @param column
     */
    columnCheckedChange(rowData: PrgScopesNode, column: string): void;
    /**
     * this function is responsible for checking or unchecking
     * all other scopes in a group
     *
     * @param toogleStatus
     * @param otherColumnsData
     */
    private groupOtherSelectionChange;
    /**
     * this function is responsible for checking or unchecking
     * all the scopes of a row, doing all the state
     * validations for the group and columns
     *
     * call method [groupOtherSelectionChange]{@link #groupOtherSelectionChange} to toogle other scopes
     *
     * @param groupName
     * @param rowData
     */
    rowSelectionChange(groupName: string, rowData: PrgScopesNode): void;
    /**
     * this function is responsible for checking or
     * unchecking all scopes in a given group
     *
     * call method [groupOtherSelectionChange]{@link #groupOtherSelectionChange} to toogle other scopes
     * @param groupName
     */
    groupSelectionChange(groupName: string): void;
    /**
     * This function is responsible for making the
     * necessary changes when a scope has its state changed.
     * Using auxiliary functions, it validates if the column,
     * row and the group in which it is inserted are totally or
     * partially with a selection or without any selection;
     *
     * Auxiliar functions:
     * [checkIfAllScopesAreSelectedByGroupColumn]{@link #checkIfAllScopesAreSelectedByGroupColumn}
     * [checkIfAllScopesAreSelectedByRow]{@link #checkIfAllScopesAreSelectedByRow}
     * [checkIfAllScopesAreSelectedByGroup]{@link #checkIfAllScopesAreSelectedByGroup}
     *
     * @param groupName
     * @param rowData
     * @param column
     */
    scopeSelectionChange(groupName: string, rowName: string, column: string): void;
    /**
     * This function validates if scopes are fully or
     * partially selected or if no scope is selected in a group
     *
     * @param rowName
     */
    private checkIfAllScopesAreSelectedByRow;
    /**
     * This function validates if scopes are fully or
     *  partially selected or if no scope is selected on a given column in a group
     *
     * Auxiliar functions:
     * [checkIfAllScopesAreSelectedForAdditional]{@link #checkIfAllScopesAreSelectedForAdditional}
     * [checkIfAllScopesAreSelectedForColumn]{@link #checkIfAllScopesAreSelectedForColumn}
     *
     * @param groupName
     * @param columnName
     */
    private checkIfAllScopesAreSelectedByGroupColumn;
    /**
     * This function validates if scopes are fully or
     * partially selected or if no scope is selected in a group
     *
     * @param groupName
     */
    private checkIfAllScopesAreSelectedByGroup;
    /**
     *this function validates whether the state of a column of other scopes
     * @param groupChildren
     * @returns boolean or null
     */
    private checkIfAllScopesAreSelectedForAdditional;
    /**
     * this is an auxiliary function that validates if a given column(default columns(crud))
     * of a group has its scopes totally or
     * partially selected or without any selection
     *
     * @param groupChildren
     * @param column
     * @returns boolean or null
     */
    private checkIfAllScopesAreSelectedForColumn;
    /**
     * this function compares the original scopes of the selected function with the currently selected scopes
     *
     * set value to [haveChangesToSave] {@link #haveChangesToSave}
     */
    private compareOriginalScopesWithCurrentScopesSelection;
    /**
     * this function returns an array with
     * all the selected scopes
     *
     * use the [getScopeObjectsFromTree] {@link getScopeObjectsFromTree} function to get a list of all the scopes
     * @returns  string[]
     */
    private getSelectedScopes;
    /**
     * this function saves all changes to a role
     *
     * calling the [updateRole]{@link /classes/AbstractRolesScopesService.html#updateRole} method from services
     */
    saveChanges(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgScopesTableComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgScopesTableComponent, "prg-scopes-table", never, { "role": "role"; }, {}, never, never, false>;
}
