/**
 * scope columns
 */
export interface PrgScopesColumns {
    /**value (true, false, null)*/
    value: boolean | null;
    /**  map with columns Data key is operationName*/
    children: Map<string, PrgScopeColumnData>;
}
/**
 * scopes columns data
 */
export interface PrgScopeColumnData {
    /** parent node */
    parent?: any;
    /**  value (true, false, null) */
    value: boolean | null;
    /**scope name EntityTypeName:OperationName*/
    scope: string | null;
    /**  these children are used when we have other operations*/
    children: Map<string, PrgScopeColumnData> | null;
    /** will be an array of strings with the keys of the other selected operations*/
    data?: any;
    /**label */
    label: string;
}
/**
 * Scope node data
 */
export interface PrgScopesNode {
    /** if it's a group or not*/
    isGroup: boolean;
    /** columns that this row has*/
    columns: PrgScopesColumns;
    /**row name*/
    name: string;
    /** label*/
    label: string;
}
