import { EventEmitter, OnInit } from '@angular/core';
import { Role } from '../../models/role.model';
import { AbstractRolesScopesService } from '../../services/roles-scopes/abstract-roles-scopes.service';
import * as i0 from "@angular/core";
/**
 * select role component
 */
export declare class PrgSelectRoleComponent implements OnInit {
    private rolesScopesService;
    /**
     * roles list
     */
    rolesList: Role[];
    /**
     * allow multi select or not
     */
    multipleSelect: boolean;
    /**
     * field that should be used as an option
     */
    optionLabel: string;
    /**
     * show search bar or not
     */
    showHeader: boolean;
    /**
     * allow button to confirm selection or not
     */
    useButton: boolean;
    /**
     * default value selected to single selections
     */
    set defaultSelected(value: Role);
    /**
     * Output with the selected roles
     */
    onSubmitRolesSelected: EventEmitter<any>;
    /**
     * Item selectable, if multiple is null else is 1
     */
    maxItemsSelectable: number;
    /**
     * roles selected when is multiple
     */
    rolesSelected: Role[];
    /**
     * Role selected when is single
     */
    roleSelected: Role;
    /**
     * Constructor
     * @param rolesScopesService
     */
    constructor(rolesScopesService: AbstractRolesScopesService);
    /**
     * ngOnInit
     *
     * set value to [rolesList]{@link #rolesList}
     *
     * call method [getAllRolesAsync]{@link /classes/AbstractRolesScopesService.html#getAllRolesAsync} from services
     */
    ngOnInit(): void;
    /**
     *this function get all roles
     */
    private getAllRoles;
    w: any;
    /**
     * This function fire [onSubmitRolesSelected]{@link #onSubmitRolesSelected} output
     */
    sendRolesSelected(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSelectRoleComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgSelectRoleComponent, "prg-select-role", never, { "rolesList": "rolesList"; "multipleSelect": "multipleSelect"; "optionLabel": "optionLabel"; "showHeader": "showHeader"; "useButton": "useButton"; "defaultSelected": "defaultSelected"; }, { "onSubmitRolesSelected": "onSubmitRolesSelected"; }, never, never, false>;
}
