import { ModalController } from "@ionic/angular";
import { Role } from "../../../models/role.model";
import * as i0 from "@angular/core";
/**
 * Modal create role
 */
export declare class PrgModalCreateRoleComponent {
    private modalCtrl;
    /**
     * list of roles to use as a basis for creating a new
     */
    rolesSelected: Role[];
    /**
     * name for the new role
     */
    newRoleName: string;
    /**
     * constructor
     *
     * @param modalCtrl
     */
    constructor(modalCtrl: ModalController);
    /**
     * receive output onAction
     *
     * @param roles
     */
    onSubmitRolesSelected(roles: Role[]): void;
    /**
     * cancel the creation of the new role
     * @returns
     */
    cancel(): Promise<boolean>;
    /**
     * create of the new role
     *
     * @returns
     */
    createRole(): Promise<boolean>;
    /**
     * Create new Role object
     *
     * @returns ROle
     */
    private createNewRoleObject;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgModalCreateRoleComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgModalCreateRoleComponent, "prg-modal-create-role", never, {}, {}, never, never, false>;
}
