import { EventEmitter } from "@angular/core";
import { ModalController } from "@ionic/angular";
import { Role } from "../../models/role.model";
import { AbstractRolesScopesService } from "../../services/roles-scopes/abstract-roles-scopes.service";
import * as i0 from "@angular/core";
/**
 * Create role component
 */
export declare class PrgCreateRoleComponent {
    private rolesScopesService;
    private modalCtrl;
    /**
     * Input placeholder
     */
    placeholder: string;
    /**
     * Button label
     */
    buttonLabel: string;
    /**
     * newRoleName
     */
    newRoleName: string;
    /**
     * output if the newRole was added successfully
     */
    addedNewRole: EventEmitter<Role>;
    /**
     * constructor
     *
     * @param rolesScopesService
     */
    constructor(rolesScopesService: AbstractRolesScopesService, modalCtrl: ModalController);
    /**
     * Create role, this function call service method [createRoleAsync]{@link /classes/AbstractRolesScopesService.html#createRoleAsync}
     */
    createRole(role: Role): void;
    /**
     * Function to open modal
     *
     * if click to save role call method [createRole]{@link #createRole}
     */
    openModalCreateRole(): Promise<void>;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgCreateRoleComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgCreateRoleComponent, "prg-create-role", never, { "placeholder": "placeholder"; "buttonLabel": "buttonLabel"; }, { "addedNewRole": "addedNewRole"; }, never, never, false>;
}
