import { TranslateService } from '@ngx-translate/core';
import { Query } from '../../models/query.model';
import { AbstractQueriesService } from './abstract-queries.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class QueriesService extends AbstractQueriesService {
    /**
     * Function responsible to store a new query
     * @param {Query} newQuery
     * @returns {Promise<Query>}
     */
    createQueryAsync(newQuery: Query): Promise<Query>;
    /**
     * Function responsible to update a query
     * @param {string} queryId
     * @param {Query} queryUpdated
     * @returns {Promise<Query>}
     */
    updateQueryAsync(queryId: string, queryUpdated: Query): Promise<Query>;
    /**
     * Constructor
     * @param {TranslateService} translateService
     */
    constructor(translateService: TranslateService);
    /**
     * Get all Queries
     * @returns {Promise<Query[]>}
     */
    getAllQueriesAsync(): Promise<Query[]>;
    /**
     * Get query by Id
     * @param {string} queryId
     * @returns {Promise<Query>}
     */
    getQueryByIdAsync(queryId: string): Promise<Query>;
    static ɵfac: i0.ɵɵFactoryDeclaration<QueriesService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<QueriesService>;
}
