import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * QueryOrderType enum
 */
export declare enum QueryOrderType {
    Ascending = 0,
    Descending = 1
}
/**
 * QueryFilterExpression enum
 */
export declare enum QueryFilterExpression {
    And = "And",
    Or = "Or"
}
/**
 * QueryFilterOperation enum
 */
export declare enum QueryFilterOperation {
    EqualTo = "EqualTo",
    NotEqualTo = "NotEqualTo",
    GreaterThan = "GreaterThan",
    GreaterThanOrEqualTo = "GreaterThanOrEqualTo",
    LessThan = "LessThan",
    LessThanOrEqualTo = "LessThanOrEqualTo",
    Between = "Between",
    Contains = "Contains",
    DoesNotContain = "DoesNotContain",
    EndsWith = "EndsWith",
    In = "In",
    IsEmpty = "IsEmpty",
    IsNotEmpty = "IsNotEmpty",
    IsNotNull = "IsNotNull",
    IsNotNullNorWhiteSpace = "IsNotNullNorWhiteSpace",
    IsNull = "IsNull",
    IsNullOrWhiteSpace = "IsNullOrWhiteSpace",
    StartsWith = "StartsWith",
    NotIn = "NotIn"
}
/**
 * QueryFilterOperationByType class that defines allowed filters operations
 * for a datatype through static properties
 */
export declare class QueryFilterOperationByType {
    /**
     * Static property to define filter operations for data type "default"
     */
    static default: QueryFilterOperation[];
    /**
     * Static property to define filter operations for data type "string"
     */
    static string: QueryFilterOperation[];
    /**
     * Static property to define filter operations for data type "date"
     */
    static date: QueryFilterOperation[];
    /**
     * Static property to define filter operations for data type "number"
     */
    static number: QueryFilterOperation[];
    /**
     * Function that returns the number of fields required for a query filter operation
     * send by parameter
     * @param queryFilterOperation
     */
    numberOfFields(queryFilterOperation: QueryFilterOperation): number;
}
/**
 * QueryColumn class that defines query results'
 * <br />properties and order
 */
export declare class QueryColumn extends BaseEntity {
    /**
     * query id (foreign key)
     */
    queryId: string;
    /**
     * Workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Column numeric order
     */
    order: number;
    /**
     * Property name
     */
    propertyName: string;
    /**
     * Constructor
     */
    constructor(init?: Partial<QueryColumn>);
}
/**
 * QueryFilter class that defines filters
 * <br/>for non-raw queries
 */
export declare class QueryFilter extends BaseEntity {
    /**
     * query id (foreign key)
     */
    queryId: string;
    /**
     * Workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Starts a group before this filter
     * <br />(opens parenthesis)
     */
    startGroup: boolean;
    /**
     * Filter property name
     */
    propertyName: string;
    /**
     * Filter value
     */
    value: any;
    /**
     * Filter additional value for operations that
     * <br />require it, e.g. Between
     */
    value2: string;
    /**
     * Filter operation
     */
    filterOperation: QueryFilterOperation;
    /**
     * Filter expression
     */
    filterExpression: QueryFilterExpression;
    /**
     * Constructor
     * @param {Partial<QueryFilter>} init
     */
    constructor(init?: Partial<QueryFilter>);
}
/**
 * QueryOrder class that defines the query
 * <br />ordenation
 */
export declare class QueryOrder extends BaseEntity {
    /**
     * query id (foreign key)
     */
    queryId: string;
    /**
     * Workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Property name
     */
    propertyName: string;
    /**
     * Order type
     */
    orderType: QueryOrderType;
    /**
     * Constructor
     */
    constructor(init?: Partial<QueryOrder>);
}
/**
 * Query class that defines a generic query
 * <br />to be executed on the database
 */
export declare class Query extends BaseEntity {
    /**
     *  Entity type id (foreign key)
     */
    entityTypeId: string;
    /**
     * Workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Is raw (sql command) query
     */
    isRaw: boolean;
    /**
     * Raw sql command to be executed
     * <br />if isRaw is true
     */
    raw: string;
    /**
     * Query filters array for non-raw queries
     */
    filters: QueryFilter[];
    /**
     * Query orders array for non-raw queries
     */
    orders: QueryOrder[];
    /**
     * Query columns array for non-raw queries
     */
    columns: QueryColumn[];
    /**
     * Query page size (LIMIT) for non-raw queries
     */
    pageSize: number;
    /**
     * Query page index for non-raw queries
     */
    pageIndex: number;
    /**
     * A description of the query
     */
    description: string;
    /**
     * Constructor
     */
    constructor(init?: Partial<Query>);
}
