import { BaseField } from '../../core/components/dynamic-form/models/base-field';
import { QueryFilterExpression, QueryFilterOperation } from './query.model';
/**
 * Class to be used on the map of Query Filter to link fields to operators and data type
 */
export declare class OperatorsAndDataType {
    /**
     * Allowed operation types for the selected field
     */
    queryFilterOperationByType: FilterOperationByTypeToTranslate[];
    /**
     * The data type for the selected field
     */
    dataType: string;
}
/**
 * Interface that defines the filters expressions and his labels to be able to translate them
 */
export interface FilterExpressionToTranslate {
    /**
     * Filters Expression
     */
    expression: QueryFilterExpression;
    /**
     * Define label to be use in template to translate
     */
    label: string;
}
/**
 * Interface that defines the filters operators and his labels to be use on OperatorsAndDataType class
 * and translate them
 */
export interface FilterOperationByTypeToTranslate {
    /**
     * Operators filters
     */
    operators: QueryFilterOperation;
    /**
     * Define label to be use in template to translate
     */
    label: string;
}
/**
 * Constant that defines the properties for each column of the Queries Filter table
 */
export declare const QueriesFilterColumns: BaseField[];
