import { TranslateService } from '@ngx-translate/core';
import { AbstractAuthService } from '../../../auth/services/auth/abstract-auth.service';
import { IsLoadingDataService } from '../../../core/services/is-loading-data/isloadingdata.service';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import { Query } from '../../models/query.model';
import { AbstractQueriesService } from '../../services/queries/abstract-queries.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class MockQueriesService extends AbstractQueriesService {
    private notificationsService;
    private utilityService;
    private isLoadingData;
    private objectUtility;
    private arrayUtilityService;
    private authService;
    /**
     * default time in seconds
     */
    private sleepTimeSec;
    /**
     * constructor
     * @param {NotificationsService} notificationsService
     * @param {UtilityService} utilityService
     * @param {IsLoadingDataService} isLoadingData
     * @param {ObjectsUtilityService} objectUtility
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {AbstractAuthService} authService
     * @param {TranslateService} translateService
     */
    constructor(notificationsService: NotificationsService, utilityService: UtilityService, isLoadingData: IsLoadingDataService, objectUtility: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, authService: AbstractAuthService, translateService: TranslateService);
    /**
     * Function responsible to store a new query
     * @param {Query} newQuery
     * @returns {Promise<Query>}
     */
    createQueryAsync(newQuery: Query): Promise<Query>;
    /**
     * Function responsible to update a query
     * @param {string} queryId
     * @param {Query} queryUpdated
     * @returns {Promise<Query>}
     */
    updateQueryAsync(queryId: string, queryUpdated: Query): Promise<Query>;
    /**
     * Get all Queries
     * @returns {Promise<Query[]>}
     */
    getAllQueriesAsync(): Promise<Query[]>;
    /**
     * Get query by Id
     * @param {string} queryId
     * @returns {Promise<Query>}
     */
    getQueryByIdAsync(queryId: string): Promise<Query>;
    static ɵfac: i0.ɵɵFactoryDeclaration<MockQueriesService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<MockQueriesService>;
}
