import { OnInit } from '@angular/core';
import { FormArray, FormGroup } from '@angular/forms';
import { PrimeNGConfig } from 'primeng/api';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { BaseAction, DynamicFormActionOutput } from '../../../core/components/dynamic-form/models/base-action';
import { BaseField } from '../../../core/components/dynamic-form/models/base-field';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { FormGroupService } from '../../../core/services/form-group/form-group.service';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { EntityType, EntityTypeProperty } from '../../../entity-types/models/entity-type.model';
import { AbstractEntityTypeService } from '../../../entity-types/services/entity-types/abstract-entity-type.service';
import { AbstractLookupTableService } from '../../../lookup-table/services/lookup-table/abstract-lookup-table.service';
import { FilterExpressionToTranslate, OperatorsAndDataType } from '../../models/query-table-filter.model';
import { Query, QueryFilterOperationByType } from '../../models/query.model';
import { AbstractQueriesService } from '../../services/queries/abstract-queries.service';
import * as i0 from "@angular/core";
/**
 * Query Modal Component
 */
export declare class PrgQueryModalComponent implements OnInit {
    querySelectedDialogRef: DynamicDialogRef;
    querySelectedDialogConfig: DynamicDialogConfig;
    private queriesService;
    private objectsUtilityService;
    private arrayUtilityService;
    private formGroupService;
    private notificationsService;
    private primengConfig;
    private entityTypeService;
    private lookupTableService;
    /**
     * Map of Operators and datatype associated to field
     * @type {Map<string, OperatorsAndDataType>}
     */
    mappedOperatorsAndDataTypeByField: Map<string, OperatorsAndDataType>;
    /**
     * A copy of mappedOperatorsAndDataTypeByField
     * @type {Map<string, OperatorsAndDataType>}
     */
    mappedOperatorsAndDataTypeByFieldCopy: Map<string, OperatorsAndDataType>;
    /**
     * Display column "Value2" when a query has a filter with two inputs values.
     *
     * Default false, hidden column.
     */
    queryHasFilterWithTwoValues: boolean;
    /**
     * The filter expressions ex:"AND" and its translations
     * @type {FilterExpressionToTranslate[]}
     */
    filterExpressions: FilterExpressionToTranslate[];
    /**
     * Create an object type QueryFilterOperationByType to
     * access his method numberOfFields on template.
     */
    operatorType: QueryFilterOperationByType;
    /**
     * A form array that belongs to the formQueryFilter
     */
    queryFilterArrayForm: FormArray<any>;
    /**
     * Class property with type Query which bind to the entity of dynamic form in template
     *
     * The query data comes from parent component.
     */
    query: Query;
    /**
     * Property with type Form Group which bind to the query filter form (only filter table)
     */
    formQueryFilter: FormGroup;
    /**
     * Property  with type boolean which bind to the checkbox in template to change query type.
     *
     * Default is true (raw query)
     */
    checkBoxQueryRaw: boolean;
    /**
     * The properties and attributes available for selection by entity type
     */
    optionsQueryFields: EntityTypeProperty[];
    /**
     * A copy of OptionsQueryFields
     */
    optionsQueryFieldsCopy: EntityTypeProperty[];
    /**
     * The dynamic form fields to build dynamic form filter query in template
     */
    queriesFilterDynamicFormFields: any[];
    /**
     * The dynamic form actions to build dynamic form filter query in template
     */
    queriesFilterDynamicFormActions: BaseAction[];
    /**
     * The dynamic form fields to build dynamic form raw query in template
     */
    queriesRawDynamicFormFields: BaseField[];
    /**
     * The dynamic form actions to build dynamic form raw query in template
     */
    queriesRawDynamicFormActions: BaseAction[];
    /**
     * Query table columns to build the formQueryFilter
     */
    queriesFilterColumns: BaseField[];
    /**
     * An array of all entity type
     * @type {EntityType[]}
     */
    entityTypeList: EntityType[];
    /**
     * This property define if component is loading data from an existing query.
     *
     * Default is true.
     * @type {boolean}
     */
    isLoading: boolean;
    /**
     * The view mode type that comes from parent component. Default is "read"
     */
    queriesViewMode: ViewMode;
    /**
     * Property that defines if you are editing a query or creating a new one.
     *
     * Default is false (new query)
     */
    private editMode;
    /**
     * The current entity type selected
     */
    private currentEntityTypeIdSelected;
    /**
     * A copy of the query that comes from the parent component.
     *
     * This property is used to reset the query to its original values
     */
    private originalQuery;
    /**
     * Constructor
     * @param {DynamicDialogRef} querySelectedDialogRef querySelectedDialogRef
     * @param {DynamicDialogConfig} querySelectedDialogConfig querySelectedDialogConfig
     * @param {AbstractQueriesService} queriesService
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {FormGroupService} formGroupService
     * @param {NotificationsService} notificationsService
     * @param {PrimeNGConfig} primengConfig
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {AbstractLookupTableService} lookupTableService
     */
    constructor(querySelectedDialogRef: DynamicDialogRef, querySelectedDialogConfig: DynamicDialogConfig, queriesService: AbstractQueriesService, objectsUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, formGroupService: FormGroupService, notificationsService: NotificationsService, primengConfig: PrimeNGConfig, entityTypeService: AbstractEntityTypeService, lookupTableService: AbstractLookupTableService);
    /**
     * ngOnInit
     *
     * Set up all configurations require to initiate properly the component
     */
    ngOnInit(): Promise<void>;
    /**
     * Get initial data (async)
     *
     * Function responsible for getting all data from api/mock required to initialize form query filter
     * @private
     */
    private getInitialData;
    /**
     * Get fields by entity type selected(async)
     *
     * Function responsible for getting all fields (properties and attributes) available
     * from api/mock by entity type selected
     * @private
     */
    private getFieldsByEntityTypeSelect;
    /**
     * Query raw action output (async)
     *
     * This function is responsible to handle actions from the dynamic raw form
     * @param {DynamicFormActionOutput} event the output from the dynamic raw form
     */
    onActionQueryRaw(event: DynamicFormActionOutput): Promise<void>;
    /**
     * Save raw query (async)
     *
     * This function is responsible to save a new raw query or update an existing one
     * @param {DynamicFormActionOutput} event the output from the dynamic raw form
     * @private
     */
    private queryRawSave;
    /**
     * Initialize Form Array of Filter Query
     * @param {boolean} editMode
     * @private
     */
    private initFormArray;
    /**
     * Initialize Query Filter Form
     * @private
     */
    private initFormQueryFilter;
    /**
     * A getter for the form array controls
     * @returns {any}
     */
    get filters(): any;
    /**
     * Delete a row of the filter query table  (async)
     * @param {number} i The table row
     *
     */
    onDeleteRow(i: number): void;
    /**
     * Changing field (async)
     *
     * Function is call whenever is a change of field value
     * @param {number} i The table row
     * @param {string}value the name of the field
     */
    onChangeField(i: number, value: string): Promise<void>;
    /**
     * Add a new element to query filter array (async)
     * @param {number} i The table row
     */
    onAddRow(i: number): Promise<void>;
    /**
     * Function is call whenever entity type value changes
     * @param {string} entityID
     *
     */
    onChangeEntity(entityID: string): Promise<void>;
    /**
     * Changing Query type
     *
     * Function is call whenever toggle button changes
     */
    onChangeQueryType(): Promise<void>;
    /**
     * Auxiliary function to create a new instance of class QueryFilter
     * with all its properties
     * @returns {QueryFilter} new Object QueryFilter
     * @private
     */
    private static newQueryFilterObject;
    /**
     * Function is call whenever operator input changes in each row
     *
     * Function is responsible to find out if any of filter rows has an
     * operator that requires two inputs values an if so makes field value2 visible and apply required validator
     */
    onCheckNumberOfFields(): void;
    /**
     * Query filter action output (async)
     *
     * This function is responsible to handle actions from the dynamic filter form
     * @param {DynamicFormActionOutput} event the output from the dynamic filter form
     */
    onActionQueryFilter(event: DynamicFormActionOutput): Promise<void>;
    /**
     * Save filter query (async)
     *
     * This function is responsible to save a new filter query or update an existing one
     * @param {DynamicFormActionOutput} event the output from the dynamic filter form
     * @private
     */
    private queryFilterSave;
    /**
     * Cancel filter query (async)
     *
     * This function is responsible to handle operations whenever cancel button is pressed
     *
     * If editing an existing query it will reset all values of the form
     *
     * If is a new one will close dialog
     * @param {DynamicFormActionOutput} event the output from the dynamic filter form
     * @private
     */
    private queryFilterCancel;
    /**
     * This Function is responsible to map datatype for the fields values and operators
     *
     * associated to the chosen property or attribute for each filter row
     * @returns {Promise<void>}
     */
    mapOperatorsAndDataTypeByField(): Promise<void>;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgQueryModalComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgQueryModalComponent, "prg-select-query", never, {}, {}, never, never, false>;
}
