import { OnDestroy, OnInit } from '@angular/core';
import { TreeNode } from 'primeng/api';
import { DialogService } from 'primeng/dynamicdialog';
import { Subscription } from 'rxjs';
import { AbstractAuthService } from '../../../auth/services/auth/abstract-auth.service';
import { BaseField } from '../../../core/components/dynamic-form/models/base-field';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { PrgQueriesConfig } from '../../models/prg-queries-config';
import { Query } from '../../models/query.model';
import { AbstractQueriesService } from '../../services/queries/abstract-queries.service';
import * as i0 from "@angular/core";
/**
 * Queries Table Component
 */
export declare class PrgQueriesTableComponent implements OnInit, OnDestroy {
    private queriesService;
    private arrayUtilityService;
    private objectsUtilityService;
    private userService;
    private prgQueriesConfig;
    dialogService: DialogService;
    /**
     * treeData
     */
    treeData: TreeNode[];
    /**
     * Queries Table columns
     */
    queriesTableColumns: BaseField[];
    /**
     * A class property used to unsubscribe observables on ngOnDestroy
     */
    subscription: Subscription[];
    /**
     * Property of type DynamicDialogRef to control the dialog
     */
    private querySelectedDialogRef;
    /**
     * Currently logged user
     */
    private loggedUserId;
    /**
     * Queries List
     */
    private queries;
    /**
     * Constructor
     * @param {AbstractQueriesService} queriesService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {AbstractAuthService} userService
     * @param {PrgQueriesConfig} prgQueriesConfig
     * @param {DialogService} dialogService dialogService
     */
    constructor(queriesService: AbstractQueriesService, arrayUtilityService: ArrayUtilityService, objectsUtilityService: ObjectsUtilityService, userService: AbstractAuthService, prgQueriesConfig: PrgQueriesConfig, dialogService: DialogService);
    /**
     * ngOnInit
     */
    ngOnInit(): Promise<void>;
    /**
     * ngOnDestroy
     *
     * Unsubscribe all subscriptions
     */
    ngOnDestroy(): void;
    /**
     * Get queries list (async)
     *
     * Function responsible to fetch all queries from api to populate table
     * @private
     */
    private getAllQueries;
    /**
     * Creation of Tree Node Object
     *
     * This function is responsible to group queries by creator  (logged user and others)
     * to organize query data for the table tree
     * @private
     */
    private createTreeNode;
    /**
     * Function responsible to open dialog when a query is clicked.
     *
     * It also manages the data that comes from dialog when it is closed.
     *
     * @param {Query} query the selected query
     */
    openQueryDialog(query: Query): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgQueriesTableComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgQueriesTableComponent, "prg-queries-table", never, {}, {}, never, never, false>;
}
