import { TranslateService } from '@ngx-translate/core';
import { LookupTable, LookupTableItem } from '../../models/lookup-table.model';
import { AbstractLookupTableService } from './abstract-lookup-table.service';
import * as i0 from "@angular/core";
/** Injectable */
export declare class LookupTableService extends AbstractLookupTableService {
    /** constructor */
    constructor(translateService: TranslateService);
    /**
     * Get all Lookup Tables
     */
    getAllLookupTableAsync(): Promise<LookupTable[]>;
    /**
     * this method is responsible for saving a new lookupTable
     * or update an existing one
     *
     * @param lookupTable
     * @returns LookupTable
     */
    saveLookupTableAsync(lookupTable: LookupTable): Promise<LookupTable>;
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables
     *
     * @param lookupTables
     * @returns LookupTable[]
     */
    saveMultipleLookupTableAsync(lookupTables: LookupTable[]): Promise<LookupTable[]>;
    /**
     * Get lookup table items by lookup table id
     * @param id
     */
    getLookupTableItemsByLookupTableIdAsync(id: string): Promise<LookupTableItem[]>;
    /**
     * Get lookup table items by lookup table name
     * @param name
     */
    getLookupTableItemsByLookupTableNameAsync(name: string): Promise<LookupTableItem[]>;
    /**
     * this method is responsible for saving a new lookupTableItem
     * or update an existing one
     * @param lookupTableItem
     */
    saveLookupTableItemAsync(lookupTableItem: LookupTableItem): Promise<LookupTableItem>;
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables items
     *
     * @param lookupTablesItems
     * @returns LookupTableItems[]
     */
    saveMultipleLookupTableItemsAsync(lookupTables: LookupTableItem[]): Promise<LookupTableItem[]>;
    /**
     * Get lookup table item by id
     * @param {string} lookUpTableItemId
     * @returns {Promise<LookupTableItem>}
     */
    getLookUpTableItemByIdAsync(lookUpTableItemId: string): Promise<LookupTableItem>;
    getMultipleLookupTableByName(lookupTableNames: string[]): Promise<LookupTable[]>;
    static ɵfac: i0.ɵɵFactoryDeclaration<LookupTableService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<LookupTableService>;
}
