import { TranslateService } from '@ngx-translate/core';
import { BaseCacheService } from '../../../core/services/cache-service/base-cache.service';
import { LookupTable, LookupTableItem } from '../../models/lookup-table.model';
/**
 * AbstractLookupTableService class that defines an
 * <br />abstract lookup tables service to
 * <br />be extended by the mock and real
 * <br />lookup tables services
 */
export declare abstract class AbstractLookupTableService extends BaseCacheService<LookupTable> {
    private translationService;
    /** constructor */
    constructor(translationService: TranslateService);
    /**
     * Get all Lookup Tables
     */
    abstract getAllLookupTableAsync(): Promise<LookupTable[]>;
    /**
     * this method is responsible for saving a new lookupTable
     * or update an existing one
     *
     * @param lookupTable
     * @returns LookupTable
     */
    abstract saveLookupTableAsync(lookupTable: LookupTable): Promise<LookupTable>;
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables
     *
     * @param lookupTables
     * @returns LookupTable[]
     */
    abstract saveMultipleLookupTableAsync(lookupTables: LookupTable[]): Promise<LookupTable[]>;
    /**
     * Get lookup table items by lookup table id
     * @param id
     */
    abstract getLookupTableItemsByLookupTableIdAsync(id: string): Promise<LookupTableItem[]>;
    /**
     * Get lookup table items by lookup table name
     * @param name
     */
    abstract getLookupTableItemsByLookupTableNameAsync(name: string): Promise<LookupTableItem[]>;
    /**
     * this method is responsible for saving a new lookupTableItem
     * or update an existing one
     * @param lookupTableItem
     */
    abstract saveLookupTableItemAsync(lookupTableItem: LookupTableItem): Promise<LookupTableItem>;
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables items
     *
     * @param lookupTablesItems
     * @returns LookupTableItems[]
     */
    abstract saveMultipleLookupTableItemsAsync(lookupTables: LookupTableItem[]): Promise<LookupTableItem[]>;
    /**
     * Get lookup table item by id
     * @param {string} lookUpTableItemId
     * @returns {Promise<LookupTableItem>}
     */
    abstract getLookUpTableItemByIdAsync(lookUpTableItemId: string): Promise<LookupTableItem>;
    /**
     * this service get translations for all lookup table items
     *
     * @param lookupTable
     * @returns
     */
    protected getTranslations(lookupTable: LookupTable): Promise<LookupTable>;
    /**
     *
     */
    abstract getMultipleLookupTableByName(lookupTableNames: string[]): Promise<LookupTable[]>;
}
