import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * LookupTableItem class that defines a look up table
 * <br />item to be used in dropowns by the front-end.
 * <br />Its form must have an name and description
 * <br />input fields that will be saved in i18n
 * <br />using an unique identifier created through
 * <br />its normalized "name" property
 */
export declare class LookupTableItem extends BaseEntity {
    /**
     * label translated
     */
    label: string;
    /**
     * Description
     */
    description: string;
    /**
     * Workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Lookup table id (foreign key)
     */
    lookupTableId: string;
}
/**
 * LookupTable class that defines a look up table
 * <br />to be used in dropowns by the front-end.
 * <br />Its form must have an name and description
 * <br />input fields that will be saved in i18n
 * <br />using an unique identifier created through
 * <br />its normalized "name" property
 */
export declare class LookupTable extends BaseEntity {
    /**
     * TranslatedName
     */
    label: string;
    /**
     * Description
     */
    description: string;
    /**
     * Entity type workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * LookupTableItems array
     */
    items: LookupTableItem[];
}
