import { TranslateService } from '@ngx-translate/core';
import { IsLoadingDataService } from '../../../../core/services/is-loading-data/isloadingdata.service';
import { NotificationsService } from '../../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../../core/services/utility/utility.service';
import { LookupTable, LookupTableItem } from '../../../models/lookup-table.model';
import { AbstractLookupTableService } from '../../../services/lookup-table/abstract-lookup-table.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class MockLookupTableService extends AbstractLookupTableService {
    private isLoadingDataService;
    private notificationsService;
    private utilityService;
    private objectsUtilityService;
    private arrayUtilityService;
    /**
     * default time in seconds
     */
    private sleepTimeSec;
    /**
     * Construtor
     *
     * @param isLoadingDataService
     * @param notificationsService
     * @param utilityService
     * @param objectsUtilityService
     */
    constructor(isLoadingDataService: IsLoadingDataService, notificationsService: NotificationsService, utilityService: UtilityService, objectsUtilityService: ObjectsUtilityService, translateService: TranslateService, arrayUtilityService: ArrayUtilityService);
    /**
     * this method returns all the lookuptables
     *
     * @returns  Promise<LookupTable[]
     */
    getAllLookupTableAsync(): Promise<LookupTable[]>;
    /**
     * this method is responsible for saving a new lookupTable
     * or update an existing one
     *
     * @param lookupTable
     * @returns LookupTable
     */
    saveLookupTableAsync(lookupTable: LookupTable): Promise<LookupTable>;
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables
     *
     * @param lookupTables
     * @returns LookupTable[]
     */
    saveMultipleLookupTableAsync(lookupTables: LookupTable[]): Promise<LookupTable[]>;
    /**
     * this method returns the items of a given lookup table
     *
     * @param id
     * @returns LookupTableItem[]
     */
    getLookupTableItemsByLookupTableIdAsync(id: string): Promise<LookupTableItem[]>;
    /**
     * this method returns the items of a given lookup table
     *
     * @param id
     * @returns LookupTableItem[]
     */
    getLookupTableItemsByLookupTableNameAsync(name: string): Promise<LookupTableItem[]>;
    /**
     * this method is responsible for saving a new lookupTable
     * or update an existing one
     *
     * @param lookupTable
     * @returns LookupTable
     */
    saveLookupTableItemAsync(lookupTableItem: LookupTableItem): Promise<LookupTableItem>;
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables items
     *
     * @param lookupTablesItems
     * @returns LookupTableItems[]
     */
    saveMultipleLookupTableItemsAsync(lookupTables: LookupTableItem[]): Promise<LookupTableItem[]>;
    /**
     * Get lookup table item by id
     * @param {string} lookUpTableItemId
     * @returns {Promise<LookupTableItem>}
     */
    getLookUpTableItemByIdAsync(lookUpTableItemId: string): Promise<LookupTableItem>;
    /**
     *
     */
    getMultipleLookupTableByName(lookupTableNames: string[]): Promise<LookupTable[]>;
    static ɵfac: i0.ɵɵFactoryDeclaration<MockLookupTableService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<MockLookupTableService>;
}
