import { OnInit } from '@angular/core';
import { AbstractControl, FormArray, FormBuilder, FormGroup } from '@angular/forms';
import { BaseField } from '../../../core/components/dynamic-form/models/base-field';
import { FormGroupService } from '../../../core/services/form-group/form-group.service';
import { IsLoadingDataService } from '../../../core/services/is-loading-data/isloadingdata.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { LookupTable } from '../../models/lookup-table.model';
import { PrgLookupTableConfig } from '../../models/prg-lookup-table-config';
import { AbstractLookupTableService } from '../../services/lookup-table/abstract-lookup-table.service';
import * as i0 from "@angular/core";
/**
 * LookupTables Component
 */
export declare class PrgLookupTableTableComponent implements OnInit {
    private lookupTableService;
    prgLookupTableConfig: PrgLookupTableConfig;
    isLoadingDataService: IsLoadingDataService;
    private formBuilder;
    private formGroupService;
    private objectsUtilityService;
    /**
     * View Child table
     */
    private dataTable;
    /**
     *  new Lookup Table Id Prefix
     */
    newLookupTableIdPrefix: string;
    /**
     * table columns
     */
    lookupTableColumns: BaseField[];
    /**
     * Lookup table form group
     */
    lookupTableForm: FormGroup;
    /**
     * cloned Lookup Table
     * this map is used to temporarily store the elements in edit mode
     */
    private clonedLookupTable;
    /**
     * auxiliary variable to help define the id of the new lookuptables
     */
    private newLookupTableIdCount;
    /**
     * constructor
     *
     * @param lookupTableService
     * @param prgLookupTableConfig prgLookupTableConfig
     * @param isLoadingDataService isLoadingDataService
     * @param formBuilder
     * @param formGroupService
     * @param objectsUtilityService
     */
    constructor(lookupTableService: AbstractLookupTableService, prgLookupTableConfig: PrgLookupTableConfig, isLoadingDataService: IsLoadingDataService, formBuilder: FormBuilder, formGroupService: FormGroupService, objectsUtilityService: ObjectsUtilityService);
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * Return lookup table form array
     */
    get lookupTableFormArray(): FormArray;
    /**
     * this function is responsible for adding a new row
     * to the table for the user to configure the new lookuptable
     *
     */
    newLookupTable(): void;
    /**
     * return lookup table  control for given lookup table
     */
    getLookupTableControlById(lookupTableId: string): AbstractControl;
    /**
     * this function is responsible for creating a
     * clone of a lookupTable that is selected for editing
     *
     * @param lookupTable
     */
    onRowEditInit(lookupTable: LookupTable): void;
    /**
     * this function is responsible for saving a lookup table,
     * either an update or adding a new lookup table to the database
     *
     * @param lookupTable
     */
    onRowEditSave(lookupTable: LookupTable): void;
    /**
     * this function is responsible for restoring the data
     * that was there before starting the edit if the
     * lookup table is already in the database,
     * otherwise it just deletes the row that was temporarily created
     *
     * @param lookupTable
     */
    onRowEditCancel(lookupTable: LookupTable): void;
    /**
     * this function is responsible for checking
     * if the lookup table already has the
     * items loaded, if not it calls the function to load them
     * @param lookupTable
     */
    expandLookupTable(lookupTable: LookupTable): void;
    /**
     * this function is responsible for saving
     * all active edits (new lines or updating existing ones)
     */
    saveAllChanges(): Promise<void>;
    /**
     * this function is responsible for discarding
     * all active edits, and resetting the data that
     * was set before starting the edit
     *
     */
    discardAllChanges(): void;
    /**
     *this function is responsible for sorting a given column
     * @param event
     */
    customSort(event: any): void;
    /**
     * this function recive the item saved in child component
     * @param event
     */
    itemsSaved(event: string): void;
    /**
     * return index of control for given lookup table
     */
    private getLookupTableControlIndexById;
    /**
     * Populate data into Form
     */
    private populateData;
    /**
     * this function is responsible for loading the
     * lookup table items for a given lookup table
     * @param lookupTable
     */
    private loadLookupTableItemsByLookupTableId;
    /**
     * this function is an auxiliary function that is used in the [saveAllChanges]{@link #saveAllChanges}
     *  function to delete all temporary rows that will be added later
     */
    private deleteAllTempLookupTable;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgLookupTableTableComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgLookupTableTableComponent, "prg-lookup-table-table", never, {}, {}, never, never, false>;
}
