import { EventEmitter } from '@angular/core';
import { AbstractControl, FormArray, FormBuilder, FormGroup } from '@angular/forms';
import { BaseField } from '../../../../../core/components/dynamic-form/models/base-field';
import { FormGroupService } from '../../../../../core/services/form-group/form-group.service';
import { IsLoadingDataService } from '../../../../../core/services/is-loading-data/isloadingdata.service';
import { ObjectsUtilityService } from '../../../../../core/services/utility/objects-utility.service';
import { LookupTableItem } from '../../../../models/lookup-table.model';
import { PrgLookupTableConfig } from '../../../../models/prg-lookup-table-config';
import { AbstractLookupTableService } from '../../../../services/lookup-table/abstract-lookup-table.service';
import * as i0 from "@angular/core";
/**
 * Lookup table items component
 */
export declare class PrgLookupTableItemsTableComponent {
    prgLookupTableConfig: PrgLookupTableConfig;
    private lookupTableService;
    isLoadingDataService: IsLoadingDataService;
    private formBuilder;
    private formGroupService;
    private objectsUtilityService;
    /**
     * View Child table
     */
    private dataTableItems;
    /**
     * Lookup Table ID
     */
    lookupTableId: string;
    /**
     * Lookup Table Items
     */
    private _lookupTableItems;
    set lookupTableItems(items: LookupTableItem[]);
    /**
     * Output with item saved
     */
    savedItems: EventEmitter<string>;
    /**
     *  new Lookup Table Id Prefix
     */
    newLookupTableItemIdPrefix: string;
    /**
     * Lookup table form group
     */
    lookupTableItemsForm: FormGroup;
    /**
     * Table columns
     */
    lookupTableItemsColumns: BaseField[];
    /**
     * Map to save temporarily the items in edit mode
     */
    private clonedLookupTableItems;
    /**
     * auxiliary variable to help define the id of the new lookuptables
     */
    private newLookupTableItemIdCount;
    /**
     * construtor
     *
     * @param prgLookupTableConfig prgLookupTableConfig
     * @param lookupTableService
     * @param isLoadingDataService isLoadingDataService
     * @param formBuilder
     * @param formGroupService
     * @param objectsUtilityService
     */
    constructor(prgLookupTableConfig: PrgLookupTableConfig, lookupTableService: AbstractLookupTableService, isLoadingDataService: IsLoadingDataService, formBuilder: FormBuilder, formGroupService: FormGroupService, objectsUtilityService: ObjectsUtilityService);
    /**
     * Return lookup table form array
     */
    get lookupTableItemsDetails(): FormArray;
    /**
     * return lookup table control for given lookup table item
     * @param lookupTableItemId
     * @returns Control
     */
    getLookupTableItemControlById(lookupTableItemId: string): AbstractControl;
    /**
     * this function is responsible for adding a new row
     * to the table for the user to configure the new lookuptableItem
     *
     */
    addNewLookupTableItem(): void;
    /**
     * this function is responsible for creating a
     * clone of a lookup Table item that is selected for editing
     *
     * @param lookupTable
     */
    onRowEditInit(item: LookupTableItem): void;
    /**
     * this function is responsible for saving a lookup table item,
     * either an update or adding a new lookup table item to the database
     *
     * @param lookupTable
     */
    onRowEditSave(item: LookupTableItem): Promise<void>;
    /**
     * this function is responsible for restoring the data
     * that was there before starting the edit if the
     * lookup table item is already in the database,
     * otherwise it just deletes the row that was temporarily created
     *
     * @param lookupTable
     */
    onRowEditCancel(item: LookupTableItem): void;
    /**
     * this function is responsible for saving
     * all active edits (new lines or updating existing ones)
     */
    saveAllChanges(): Promise<void>;
    /**
     * this function is responsible for discarding
     * all active edits, and resetting the data that
     * was set before starting the edit
     */
    discardAllChanges(): void;
    /**
     * this function is responsible for sorting a given column
     * @param event
     */
    customSort(event: any): void;
    /**
     * return lookup table item control for given lookup table item id
     * @param lookupTableItemId
     * @returns number
     */
    private getLookupTableItemControlIndexById;
    /**
     * Populate data into Form
     */
    private populateFormGroup;
    /**
     * this function is an auxiliary function that is used in the [saveAllChanges]{@link #saveAllChanges}
     *  function to delete all temporary rows that will be added later
     */
    private deleteAllTempLookupTable;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgLookupTableItemsTableComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgLookupTableItemsTableComponent, "prg-lookup-table-items-table", never, { "lookupTableId": "lookupTableId"; "lookupTableItems": "lookupTableItems"; }, { "savedItems": "savedItems"; }, never, never, false>;
}
