import { TranslateService } from '@ngx-translate/core';
import { Observable } from 'rxjs';
import { PrgAuthConfig } from '../../auth/models/prg-auth-config';
import { PrgConfigurationItemsConfig } from '../../configuration-items/models/prg-configuration-items-config';
import { ArrayUtilityService } from '../../core/services/utility/array-utility.service';
import { UtilityService } from '../../core/services/utility/utility.service';
import { PrgDashboardConfig } from '../../dashboard/models/prg-dashboard-config';
import { PrgEntityTypesConfig } from '../../entity-types/models/prg-entity-types-config';
import { PrgLookupTableConfig } from '../../lookup-table/models/prg-lookup-table-config';
import { PrgQueriesConfig } from '../../queries/models/prg-queries-config';
import { PrgRolesScopesConfig } from '../../roles-scopes/models/prg-roles-scopes-config';
import { PrgTermsConfig } from '../../terms/models/prg-terms-config';
import { PrgMenuItem } from '../models/prg-menu-item';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class MainLayoutService {
    private authConfig;
    private entityTypesConfig;
    private lookupTableConfig;
    private queriesConfig;
    private rolesScopesConfig;
    private termsConfig;
    private configItemsConfig;
    private dashboardConfig;
    private arrayUtility;
    private translateService;
    private utilityService;
    /**
     * Current state of SideBar
     */
    private sideBarSubject;
    /**
     * Show/hide header subject
     * @type {BehaviorSubject<boolean>}
     * @private
     */
    private displayHeaderSubject;
    /**
     * constructor
     * @param {PrgAuthConfig} authConfig
     * @param {PrgEntityTypesConfig} entityTypesConfig
     * @param {PrgLookupTableConfig} lookupTableConfig
     * @param {PrgQueriesConfig} queriesConfig
     * @param {PrgRolesScopesConfig} rolesScopesConfig
     * @param {PrgTermsConfig} termsConfig
     * @param {PrgDashboardConfig} dashboardConfig
     * @param {PrgConfigurationItemsConfig} configItemsConfig
     * @param {ArrayUtilityService} arrayUtility
     * @param {TranslateService} translateService
     * @param {UtilityService} utilityService
     */
    constructor(authConfig: PrgAuthConfig, entityTypesConfig: PrgEntityTypesConfig, lookupTableConfig: PrgLookupTableConfig, queriesConfig: PrgQueriesConfig, rolesScopesConfig: PrgRolesScopesConfig, termsConfig: PrgTermsConfig, configItemsConfig: PrgConfigurationItemsConfig, dashboardConfig: PrgDashboardConfig, arrayUtility: ArrayUtilityService, translateService: TranslateService, utilityService: UtilityService);
    /**
     * Setter for sideBarSubject
     * @param value
     */
    setSideBarState(value: any): void;
    /**
     * Getter for sideBarSubject
     *
     * @returns The sideBarSubject as an observable
     */
    getSideBarStateObservable(): Observable<any>;
    /**
     * Getter for sideBarSubject
     *
     * @returns The sideBarSubject current value
     */
    getSideBarStateValue(): any;
    /**
     * Setter for displayHeaderSubject
     * @param value
     */
    setDisplayHeaderState(value: boolean): void;
    /**
     * Getter for displayHeaderSubject
     *
     * @returns The sideBarSubject as an observable
     */
    getDisplayHeaderStateObservable(): Observable<boolean>;
    /**
     * Getter for displayHeaderSubject
     *
     * @returns The sideBarSubject current value
     */
    getDisplayHeaderStateValue(): any;
    /**
  
    /**
     * Function responsible to complete sidebar menu with labels of selected language
     * @param {PrgMenuItem[]} mainMenu
     * @param {boolean} mainMenuExpanded
     * @returns {Promise<MenuItem[]>}
     */
    getSideBarMenuItemsWithLabelsAsync(mainMenu: PrgMenuItem[], mainMenuExpanded: boolean): Promise<PrgMenuItem[]>;
    /**
     * Function responsible to complete header menus (user and language) with labels of selected language
     * @param {PrgMenuItem[]} menuItem
     * @returns {Promise<PrgMenuItem[]>}
     */
    getHeaderMenuItemsWithLabelsAsync(menuItem: PrgMenuItem[]): Promise<PrgMenuItem[]>;
    /**
     * Function responsible to handle auxiliary string properties of menu type PrgMenuItem
     * @param {PrgMenuItem[]} menuItems
     * @param context
     * @returns {PrgMenuItem[]}
     */
    mapMenuItemsHelpers(menuItems: PrgMenuItem[], context: any): PrgMenuItem[];
    static ɵfac: i0.ɵɵFactoryDeclaration<MainLayoutService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<MainLayoutService>;
}
