import { QueryParamsHandling } from '@angular/router';
import { MenuItem } from 'primeng/api';
/**
 * Interface that implements Menu Item interface from PrimeNg and add auxiliary properties to handle visibility, commands and router link of items
 */
export declare class PrgMenuItem implements MenuItem {
    /**
     * A key of an action to be used on grouped action buttons
     * @type {BaseActionKey}
     */
    key?: string;
    /**
     * An identifier for grouped action buttons to know which one has been actuated on dynamic forms
     * @type {string}
     */
    group?: string;
    /**
     * The translation base path for item
     * @type {string}
     */
    translationBasePath?: string;
    /**
     * A string of the command that will be placed on command property
     * @type {string}
     */
    commandString?: string;
    /**
     * A string of the visibility expression that will be placed on visibility property
     * @type {string}
     */
    visibleString?: string;
    /**
     * A string of the route path expression that will be placed on router link property
     * @type {string}
     */
    routerLinkString?: string;
    /**
     * Text of the item.
     * @type {string}
     */
    label?: string;
    /**
     * 	Icon of the item.
     * @type {string}
     */
    icon?: string;
    /**
     * Callback to execute when item is clicked.
     * @type {(event?: any) => void}
     */
    command?: (event?: any) => void;
    /**
     * External link to navigate when item is clicked.
     * @type {string}
     */
    url?: string;
    /**
     * An array of children menuitems.
     * @type {PrgMenuItem[]}
     */
    items?: PrgMenuItem[];
    /**
     * Visibility of submenu.
     * @type {boolean}
     */
    expanded?: boolean;
    /**
     * When set as true, disables the menuitem.
     * @type {boolean}
     */
    disabled?: boolean;
    /**
     * Whether the dom element of menuitem is created or not.
     * @type {boolean}
     */
    visible?: boolean;
    /**
     * Specifies where to open the linked document.
     * @type {string}
     */
    target?: string;
    /**
     * Whether to escape the label or not. Set to false to display html content.
     * @type {boolean}
     */
    escape?: boolean;
    /**
     * Configuration for active router link.
     * @type {any}
     */
    routerLinkActiveOptions?: any;
    /**
     * Defines the item as a separator.
     * @type {boolean}
     */
    separator?: boolean;
    /**
     * Value of the badge.
     * @type {string}
     */
    badge?: string;
    /**
     *  Tooltip label
     * @type {string}
     */
    tooltip?: string;
    /**
     * Tooltip position
     * @type {string}
     */
    tooltipPosition?: string;
    /**
     * Style class of the badge.
     * @type {string}
     */
    badgeStyleClass?: string;
    /**
     * Inline style of the menuitem.
     * @type {any}
     */
    style?: any;
    /**
     * Style class of the menuitem.
     * @type {string}
     */
    styleClass?: string;
    /**
     * Tooltip text of the item.
     * @type {string}
     */
    title?: string;
    /**
     * Identifier of the element.
     * @type {string}
     */
    id?: string;
    /**
     * Value of HTML data-* attribute.
     * @type {any}
     */
    automationId?: any;
    /**
     * Specifies tab order of the item.
     * @type {string}
     */
    tabindex?: string;
    /**
     * RouterLink definition for internal navigation.
     * @type {any}
     */
    routerLink?: any;
    /**
     * Query parameters for internal navigation via routerLink.
     * @type {{[p: string]: any}}
     */
    queryParams?: {
        [k: string]: any;
    };
    /**
     * Sets the hash fragment for the URL.
     * @type {string}
     */
    fragment?: string;
    /**
     * How to handle query parameters in the router link for the next navigation. One of:
     *
     * merge : Merge new with current parameters.
     * preserve : Preserve current parameters.k.
     * @type {QueryParamsHandling}
     */
    queryParamsHandling?: QueryParamsHandling;
    /**
     * 	When true, preserves the URL fragment for the next navigation.
     * @type {boolean}
     */
    preserveFragment?: boolean;
    /**
     * When true, navigates without pushing a new state into history.
     * @type {boolean}
     */
    skipLocationChange?: boolean;
    /**
     * When true, navigates while replacing the current state in history.
     * @type {boolean}
     */
    replaceUrl?: boolean;
    /**
     * Inline style of the item's icon.
     * @type {any}
     */
    iconStyle?: any;
    /**
     * Style class of the icon.
     * @type {string}
     */
    iconClass?: string;
    /**
     * 	Developer-defined state that can be passed to any navigation.
     * @type {{[p: string]: any}}
     */
    state?: {
        [k: string]: any;
    };
    /**
     * Options of the item's tooltip.
     * @type {{tooltipLabel?: string, tooltipPosition?: string, tooltipEvent?: string, appendTo?: any, positionStyle?: string, tooltipStyleClass?: string, tooltipZIndex?: string, escape?: boolean, disabled?: boolean, positionTop?: number, positionLeft?: number, showDelay?: number, hideDelay?: number, life?: number}}
     */
    tooltipOptions?: {
        tooltipLabel?: string;
        tooltipPosition?: string;
        tooltipEvent?: string;
        appendTo?: any;
        positionStyle?: string;
        tooltipStyleClass?: string;
        tooltipZIndex?: string;
        escape?: boolean;
        disabled?: boolean;
        positionTop?: number;
        positionLeft?: number;
        showDelay?: number;
        hideDelay?: number;
        life?: number;
    };
}
