import { OnDestroy, OnInit } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { AbstractAuthService } from '../../../auth/services/auth/abstract-auth.service';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { PrgMenuItem } from '../../models/prg-menu-item';
import { MainLayoutService } from '../../services/main-layout.service';
import * as i0 from "@angular/core";
/**
 * Component decorator
 */
export declare class PrgSidebarComponent implements OnInit, OnDestroy {
    mainLayoutService: MainLayoutService;
    private arrayUtility;
    private translateService;
    private authService;
    private objectsUtilityService;
    /**
     * The current state of sidebar menu. Expanded is true and collapsed is false.
     *
     * Default is false.
     * @type {boolean}
     */
    mainMenuExpanded: boolean;
    /**
     * Menu Items data related to the expanded menu
     * @type {MenuItem[]}
     */
    mainMenu: PrgMenuItem[];
    /**
     * Menu Items data related to the collapsed menu
     * @type {MenuItem[]}
     */
    mainMenuIcons: PrgMenuItem[];
    /**
     * A class property used to unsubscribe observables on ngOnDestroy
     * @type {Subscription}
     * @private
     */
    private subscription;
    /**
     * The original Menu data
     * @type {PrgMenuItem[]}
     * @private
     */
    private mainMenuOriginal;
    /**
     * Currently log user
     * @type {User}
     * @private
     */
    private user;
    /**
     * Defines if header is displayed or not.
     * @type {boolean}
     */
    headerDisplay: boolean;
    /**
     * Constructor
     * @param {MainLayoutService} mainLayoutService mainLayoutService
     * @param {ArrayUtilityService} arrayUtility
     * @param {TranslateService} translateService
     * @param {AuthService} authService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(mainLayoutService: MainLayoutService, arrayUtility: ArrayUtilityService, translateService: TranslateService, authService: AbstractAuthService, objectsUtilityService: ObjectsUtilityService);
    /**
     * ngOnInit
     *
     * This method is responsible for:
     *
     * Get the saved state of sidebar in local storage.
     *
     * Verify if are any changes on language selected through on observable
     *
     * @returns {Promise<void>}
     */
    ngOnInit(): Promise<void>;
    /**
     * This method is responsible for calling the functions that will build the menus, one with labels and icons and other with only icons
     * @returns {Promise<void>}
     * @private
     */
    private getMainMenuItems;
    /**
     * ngOnDestroy
     *
     * Unsubscribe all the observables
     */
    ngOnDestroy(): void;
    /**
     * This function is responsible to save the current state of the sidebar menu (expanded - true or collapsed - false) in local storage
     * @returns {Promise<void>}
     */
    onShowHideSideBarDetails(): Promise<void>;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgSidebarComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgSidebarComponent, "prg-sidebar", never, { "mainMenuOriginal": "mainMenuOriginal"; }, {}, never, never, false>;
}
