import { OnDestroy, OnInit } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { User } from '../../../auth/models/user.model';
import { AbstractAuthService } from '../../../auth/services/auth/abstract-auth.service';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { PrgMenuItem } from '../../models/prg-menu-item';
import { MainLayoutService } from '../../services/main-layout.service';
import * as i0 from "@angular/core";
/**
 * Header Component
 */
export declare class PrgHeaderComponent implements OnInit, OnDestroy {
    private authService;
    private objectUtilityService;
    private arrayUtilityService;
    private translateService;
    private mainLayoutService;
    /**
     * Property of the class with type string which bind to menu logo.
     */
    imagePathLogo: string;
    /**
     * Property of the class with type string which bind to user default image
     */
    imagePathUserDefault: string;
    /**
     * Property of the class with type string which bind to user image
     */
    imagePathUser: string;
    /**
     * Current logged user
     * @type {User}
     */
    user: User;
    /**
     * A class property used to unsubscribe observables on ngOnDestroy
     * @type {Subscription[]}
     * @private
     */
    private subscription;
    /**
     * A class property that defines if header is display
     * @type {boolean}
     */
    displayHeader: boolean;
    /**
     * Menu Items data of user menu
     * @type {PrgMenuItem[]}
     */
    menuItemsUser: PrgMenuItem[];
    /**
     * Menu Items data of language menu
     * @type {PrgMenuItem[]}
     */
    menuItemsLanguage: PrgMenuItem[];
    /**
     * Constructor
     * @param {AbstractAuthService} authService
     * @param {ObjectsUtilityService} objectUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {TranslateService} translateService
     * @param {MainLayoutService} mainLayoutService
     */
    constructor(authService: AbstractAuthService, objectUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, translateService: TranslateService, mainLayoutService: MainLayoutService);
    /**
     * ngOnInit
     *
     * @returns {Promise<void>}
     */
    ngOnInit(): Promise<void>;
    /**
     * Function responsible to reload menu data when user change language
     * @param {string} lang
     * @returns {Promise<void>}
     */
    changeLanguage(lang: string): Promise<void>;
    /**
     * ngOnDestroy
     *
     * Unsubscribe the user logged observable
     */
    ngOnDestroy(): void;
    /**
     * This method is responsible for calling the functions that will build the language menu
     * @returns {Promise<void>}
     */
    initMenuLanguage(): Promise<void>;
    /**
     * This method is responsible for calling the functions that will build the user menu
     * @returns {Promise<void>}
     */
    initMenuUser(): Promise<void>;
    /**
     * This method is responsible for calling the function that will log out user
     * @returns {Promise<void>}
     */
    private onClickLogout;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgHeaderComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgHeaderComponent, "prg-header", never, { "imagePathLogo": "imagePathLogo"; "imagePathUserDefault": "imagePathUserDefault"; "menuItemsUser": "menuItemsUser"; "menuItemsLanguage": "menuItemsLanguage"; }, {}, never, never, false>;
}
