import { TranslateService } from '@ngx-translate/core';
import { PaginationResponse } from '../../../core/models/pagination-response';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { EntityType, EntityTypeAttribute, EntityTypeOperation, EntityTypeProperty } from '../../models/entity-type.model';
import { AbstractEntityTypeService } from './abstract-entity-type.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class EntityTypeService extends AbstractEntityTypeService {
    /**
     * constructor
     * @param notificationsService notificationsService
     * @param translateService translateService
     */
    constructor(notificationsService: NotificationsService, translateService: TranslateService);
    /**
     * Get all Entity Types
     *
     * @Returns Entity types[]
     */
    getEntityTypeListAsync(): Promise<EntityType[]>;
    /**
     * Get entity type list with operation
     *
     *  * @Returns Entity types[]
     */
    getEntityTypeListWithOperationAsync(): Promise<EntityType[]>;
    /**
     * save entity type
     * @param entityType
     * @return Entity type
     */
    saveEntityTypeAsync(entityType: EntityType): Promise<EntityType>;
    /**
     * get all operations of an entity
     * @param entityTypeId
     * @return EntityTypeOperation[]
     */
    getAllOperationsByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeOperation[]>;
    /**
     * add or update entity type operation
     * @param entityTypeOperation
     * @return EntityTypeOperation
     */
    saveEntityTypeOperationAsync(entityTypeOperation: EntityTypeOperation): Promise<EntityTypeOperation>;
    /**
     * get all attributes of an entity
     * @param entityTypeId
     * @return EntityTypeAttribute[]
     */
    getAllAttributesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeAttribute[]>;
    /**
     * add or update entity type attribute
     * @param entityTypeAttribute
     * @return EntityTypeAttribute
     */
    saveEntityTypeAttributeAsync(entityTypeAttribute: EntityTypeAttribute): Promise<EntityTypeAttribute>;
    /**
     * get all properties of an entity
     * @param entityTypeId
     * @return EntityTypeProperty[]
     */
    getAllPropertiesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeProperty[]>;
    /**
     * add or update entity type property
     * @param EntityTypeProperty
     * @return EntityTypeProperty
     */
    saveEntityTypePropertyAsync(entityTypeProperty: EntityTypeProperty): Promise<EntityTypeProperty>;
    /**
     * update entity type properties using patch logic
     * @param entityTypesPropertiesToPatch
     * @return EntityTypeProperty[]
     */
    updateEntityTypePropertiesAsync(entityTypesPropertiesToPatch: Map<string, any>): Promise<EntityTypeProperty[]>;
    /**
     * update entity type attributes using patch logic
     * @param entityTypesAttributesToPatch
     * @return EntityTypeAttribute[]
     */
    updateEntityTypeAttributesAsync(entityTypesAttributesToPatch: Map<string, any>): Promise<EntityTypeAttribute[]>;
    /**
     * this service returns all the data (properties, attributes and operations)
     * of a given entity type (by entity name)
     * @param entityTypeName
     */
    getAllEntityTypeDataByName(entityTypeName: string): Promise<EntityType>;
    /**
     * this service returns an array of elements
     * of the entity sent as a parameter,
     *  based on the filter it receives as a parameter.
     * @param entityTypeName
     * @param FilterGroup
     */
    getEntityTypeElements(entityTypeName: string, FilterGroup: any): Promise<PaginationResponse>;
    getAllPropertiesAndAttributesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeProperty[]>;
    /**
     * This service return a element from a entity type list by id
     * @param entityTypeName
     * @param elementId
     */
    getEntityTypeElementById(entityTypeName: string, elementId: string): Promise<any>;
    /**
     * this service excute in database the operation received as parameter
     * @param entityName
     * @param operation
     * @param entity
     */
    executeAction(entityName: string, operation: EntityTypeOperation, entity: any): Promise<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<EntityTypeService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<EntityTypeService>;
}
