import { TranslateService } from '@ngx-translate/core';
import { PaginationResponse } from '../../../core/models/pagination-response';
import { BaseCacheService } from '../../../core/services/cache-service/base-cache.service';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { EntityType, EntityTypeAttribute, EntityTypeOperation, EntityTypeProperty } from '../../models/entity-type.model';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare abstract class AbstractEntityTypeService extends BaseCacheService<EntityType> {
    protected notificationsService: NotificationsService;
    private translationService;
    /**
     * constructor
     * @param notificationsService notificationsService
     * @param translationService
     */
    constructor(notificationsService: NotificationsService, translationService: TranslateService);
    /**
     * Get all Entity Types
     *
     * @Returns Entity types[]
     */
    abstract getEntityTypeListAsync(): Promise<EntityType[]>;
    /**
     * Get entity type list with operation
     *
     *  * @Returns Entity types[]
     */
    abstract getEntityTypeListWithOperationAsync(): Promise<EntityType[]>;
    /**
     * save entity type
     * @param entityType
     * @return Entity type
     */
    abstract saveEntityTypeAsync(entityType: EntityType): Promise<EntityType>;
    /**
     * get all operations of an entity
     * @param entityTypeId
     * @return EntityTypeOperation[]
     */
    abstract getAllOperationsByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeOperation[]>;
    /**
     * add or update entity type operation
     * @param entityTypeOperation
     * @return EntityTypeOperation
     */
    abstract saveEntityTypeOperationAsync(entityTypeOperation: EntityTypeOperation): Promise<EntityTypeOperation>;
    /**
     * get all attributes of an entity
     * @param entityTypeId
     * @return EntityTypeAttribute[]
     */
    abstract getAllAttributesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeAttribute[]>;
    /**
     * add or update entity type attribute
     * @param entityTypeAttribute
     * @return EntityTypeAttribute
     */
    abstract saveEntityTypeAttributeAsync(entityTypeAttribute: EntityTypeAttribute): Promise<EntityTypeAttribute>;
    /**
     * get all properties of an entity
     * @param entityTypeId
     * @return EntityTypeProperty[]
     */
    abstract getAllPropertiesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeProperty[]>;
    /**
     * add or update entity type property
     * @param EntityTypeProperty
     * @return EntityTypeProperty
     */
    abstract saveEntityTypePropertyAsync(entityTypeProperty: EntityTypeProperty): Promise<EntityTypeProperty>;
    /**
     * update entity type properties using patch logic
     * @param entityTypesPropertiesToPatch
     * @return EntityTypeProperty[]
     */
    abstract updateEntityTypePropertiesAsync(entityTypesPropertiesToPatch: Map<string, any>): Promise<EntityTypeProperty[]>;
    /**
     * update entity type attributes using patch logic
     * @param entityTypesAttributesToPatch
     * @return EntityTypeAttribute[]
     */
    abstract updateEntityTypeAttributesAsync(entityTypesAttributesToPatch: Map<string, any>): Promise<EntityTypeAttribute[]>;
    /**
     * this service returns all the data (properties, attributes and operations)
     * of a given entity type (by entity name)
     * @param entityTypeName
     */
    abstract getAllEntityTypeDataByName(entityTypeName: string): Promise<EntityType>;
    /**
     * this service returns an array of elements
     * of the entity sent as a parameter,
     *  based on the filter it receives as a parameter.
     * @param entityTypeName
     * @param FilterGroup
     */
    abstract getEntityTypeElements(entityTypeName: string, FilterGroup: any): Promise<PaginationResponse>;
    protected getTranslationsAsync(entities: EntityType[] | EntityType): Promise<EntityType[] | EntityType>;
    /**
     * Get all properties and attributes by entity type id
     * @param {string} entityTypeId The entity type id
     * @returns {Promise<EntityTypeProperty[]>}
     */
    abstract getAllPropertiesAndAttributesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeProperty[]>;
    /**
     * This service return a element from a entity type list by id
     * @param entityTypeName
     * @param elementId
     */
    abstract getEntityTypeElementById(entityTypeName: string, elementId: string): Promise<any>;
    /**
     * this service excute in database the operation received as parameter
     * @param entityName
     * @param operation
     * @param entity
     */
    abstract executeAction(entityName: string, operation: EntityTypeOperation, entity: any): Promise<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<AbstractEntityTypeService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<AbstractEntityTypeService>;
}
