import { OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { EntityType } from '../../models/entity-type.model';
import { AbstractEntityTypeService } from '../../services/entity-types/abstract-entity-type.service';
import * as i0 from "@angular/core";
export declare class PrgEntityTypeElementPage implements OnInit {
    private route;
    private router;
    private entityTypeService;
    private objectsUtilityService;
    /**
     * entityTypeName
     */
    private entityTypeName;
    /**
     * entityTypeElementID
     */
    private entityTypeElementID;
    /**
     * entityType
     */
    entityType: EntityType;
    /**
     * element
     */
    element: any;
    /**
     * viewMode
     */
    viewMode: ViewMode;
    /**
     * constructor
     * @param route
     * @param router
     * @param entityTypeService
     * @param objectsUtilityService
     */
    constructor(route: ActivatedRoute, router: Router, entityTypeService: AbstractEntityTypeService, objectsUtilityService: ObjectsUtilityService);
    /**
     * ngOnInit
     */
    ngOnInit(): Promise<void>;
    /**
     * this function fetches the data from the entityType based on the entity type name
     * @param entityTypeName
     */
    private getEntityTypeData;
    /**
     * this function fetches the data from the entityType
     * element based on the entity type name and element id
     * @param entitiesTypeName
     * @param elementId
     * @returns
     */
    private getEntityTypeElementData;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgEntityTypeElementPage, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgEntityTypeElementPage, "prg-entity-type-element-page", never, {}, {}, never, never, false>;
}
