import { BaseField } from '../../core/components/dynamic-form/models/base-field';
import { TableConfigs } from '../../core/models/table-configs';
/**
 * Interface that defines the data that can be
 * <br />passed by the consuming app to the module
 */
export interface PrgEntityTypesConfig {
    /**
     * If useMockServicess is true, the Mock Services will be used,
     * <br />else the real API Services will be used
     */
    useMockServices: boolean;
    /**
     * The base path to be used on the PrgEntityTypesRoutingModule
     */
    entityTypeBasePath: string;
    /**
     * lookup table columns
     */
    entityTypeTableColumns: BaseField[];
    /**
     * lookupTableDataTypeItemId, lookup table item id of
     * DataType LookupTable, to be used on the dynamic form's
     * visibility expressions
     */
    lookupTableDataTypeItemId: string;
    /**
     * entityTypeDataTypeItemId, lookup table item id of
     * DataType EntityType, to be used on the dynamic form's
     * visibility expressions
     */
    entityTypeDataTypeItemId: string;
    /**
     * define a set of configurations for the table
     */
    specificEntityTypeListConfigs: TableConfigs;
}
