import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * HttpVerb string enum
 */
export declare enum HttpVerb {
    Get = "GET",
    Post = "POST",
    Put = "PUT",
    Patch = "PATCH",
    Delete = "DELETE"
}
/**
 * EntityTypeProperty class that defines a dynamic
 * <br />property of an EntityType, which WILL BE
 * <br />COMPILED into the dll
 */
export declare class EntityTypeProperty extends BaseEntity {
    /**
     * Entity type workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Defines a label to be used in template and translations
     */
    label: string;
    /**
     * Entity type id (foreign key)
     */
    entityTypeId: string;
    /**
     * Gui Settings to be used by generic components
     * <br /> on the front-end. JSON stringified object
     */
    guiSettings: string;
    /**
     * Lookup table item id for datatype (foreign key)
     */
    dataTypeId: string;
    /**
     * this field is to indicate if
     * we are going to have an array of some type
     */
    isArray: boolean;
    /**
     * Property order
     */
    order: number;
    /**
     * group
     */
    group?: string;
    /**
     * Property reference, used when DataType is:
     * <br />LookupTable or EntityType
     */
    reference: string;
    /**
     * constructor
     * @param init
     */
    constructor(init?: Partial<EntityTypeProperty>);
}
/**
 * EntityTypeAttribute class that defines an
 * <br />attribute of an EntityType, which WILL NOT
 * <br />BE COMPILED into the dll
 */
export declare class EntityTypeAttribute extends BaseEntity {
    /**
     * Entity type workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Defines a label to be used in template and translations
     */
    label: string;
    /**
     * Entity type id (foreign key)
     */
    entityTypeId: string;
    /**
     * Gui Settings to be used by generic components
     * <br /> on the front-end. JSON stringified object
     */
    guiSettings: string;
    /**
     * Lookup table item id for datatype (foreign key)
     */
    dataTypeId: string;
    /**
     * this field is to indicate if
     * we are going to have an array of some type
     */
    isArray: boolean;
    /**
     * Attribute order
     */
    order: number;
    /**group */
    group?: string;
    /**
     * Attribute reference, used when DataType is:
     * <br />LookupTable or EntityType
     */
    reference: string;
    /**constructor */
    constructor(init?: Partial<EntityTypeAttribute>);
}
/**
 * EntityTypeOperation class that defines a
 * <br />custom operation for an EntityType,
 * <br />which WILL BE COMPILED into the dll
 */
export declare class EntityTypeOperation extends BaseEntity {
    /**
     * Entity type workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Defines a label to be used in template and translations
     */
    label: string;
    /**
     * Entity type id (foreign key)
     */
    entityTypeId: string;
    /**
     * Gui Settings to be used by generic components
     * <br /> on the front-end. JSON stringified object
     */
    guiSettings: string;
    /**
     * Operation overrides an existing controller method
     */
    override: boolean;
    /**
     * Array of imports to be imported by the controller
     */
    imports: string[];
    /**
     * Source code to be executed for the given operation
     * <br />by the controller
     */
    sourceCode: string;
    /**
     * Operation HttpVerb
     */
    httpVerb: HttpVerb;
    /**
     * Operation order
     */
    order: number;
    /**constructor */
    constructor(init?: Partial<EntityTypeOperation>);
}
/**
 * EntityTypeOperation class that defines a
 * <br />generic EntityType, its properties,
 * <br />attributes and operations
 */
export declare class EntityType extends BaseEntity {
    /**
     * state id
     */
    stateId?: string;
    /**
     * Defines a label to be used in template and translations
     */
    label: string;
    /**
     * Workspace id (foreign key)
     */
    workspaceId: string;
    /**
     * Gui Settings to be used by generic components
     * <br /> on the front-end. JSON stringified object
     */
    guiSettings: string;
    /**
     * Group name to be used on the front-end for
     * scopes configuration grouping
     */
    group: string;
    /**
     * Properties array
     */
    properties: EntityTypeProperty[];
    /**
     * Attributes array
     */
    attributes: EntityTypeAttribute[];
    /**
     * Operations array
     */
    operations: EntityTypeOperation[];
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init?: Partial<EntityType>);
}
