import { TranslateService } from '@ngx-translate/core';
import { FilterGroup } from '../../../../core/models/filters';
import { PaginationResponse } from '../../../../core/models/pagination-response';
import { IsLoadingDataService } from '../../../../core/services/is-loading-data/isloadingdata.service';
import { NotificationsService } from '../../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../../core/services/utility/utility.service';
import { EntityType, EntityTypeAttribute, EntityTypeOperation, EntityTypeProperty } from '../../../models/entity-type.model';
import { AbstractEntityTypeService } from '../../../services/entity-types/abstract-entity-type.service';
import * as i0 from "@angular/core";
/**
 * injectable
 */
export declare class MockEntityTypesService extends AbstractEntityTypeService {
    private utilityService;
    private objectsUtilityService;
    private arrayUtilityService;
    private isLoadingData;
    /**
     * default time in seconds
     */
    private sleepTimeSec;
    /**
     * constructor
     * @param utilityService
     * @param objectsUtilityService
     * @param notificationsService
     * @param arrayUtilityService
     * @param isLoadingData
     * @param translateService
     */
    constructor(utilityService: UtilityService, objectsUtilityService: ObjectsUtilityService, notificationsService: NotificationsService, arrayUtilityService: ArrayUtilityService, isLoadingData: IsLoadingDataService, translateService: TranslateService);
    /**
     * Get all Entity Types
     *
     * @Returns Entity types[]
     */
    getEntityTypeListAsync(): Promise<EntityType[]>;
    /**
     * Get entity type list with operation
     *
     *  @Returns Entity types[]
     */
    getEntityTypeListWithOperationAsync(): Promise<EntityType[]>;
    /**
     * save entity type
     * @param entityType
     * @return Entity type
     */
    saveEntityTypeAsync(entityType: EntityType): Promise<EntityType>;
    /**
     * get all operations of an entity
     * @param entityTypeId
     * @return EntityTypeOperation[]
     */
    getAllOperationsByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeOperation[]>;
    /**
     * add or update entity type operation
     * @param entityTypeOperation
     * @return EntityTypeOperation
     */
    saveEntityTypeOperationAsync(entityTypeOperation: EntityTypeOperation): Promise<EntityTypeOperation>;
    /**
     * get all attributes of an entity
     * @param entityTypeId
     * @return EntityTypeAttribute[]
     */
    getAllAttributesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeAttribute[]>;
    /**
     * add or update entity type attribute
     * @param entityTypeAttribute
     * @return EntityTypeAttribute
     */
    saveEntityTypeAttributeAsync(entityTypeAttribute: EntityTypeAttribute): Promise<EntityTypeAttribute>;
    /**
     * get all properties of an entity
     * @param entityTypeId
     * @return EntityTypeProperty[]
     */
    getAllPropertiesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeProperty[]>;
    /**
     * add or update entity type property
     * @param EntityTypeProperty
     * @return EntityTypeProperty
     */
    saveEntityTypePropertyAsync(entityTypeProperty: EntityTypeProperty): Promise<EntityTypeProperty>;
    /**
     * update entity type properties using patch logic
     * @param entityTypesPropertiesToPatch
     * @return EntityTypeProperty[]
     */
    updateEntityTypePropertiesAsync(entityTypesPropertiesToPatch: Map<string, any>): Promise<EntityTypeProperty[]>;
    /**
     * update entity type attributes using patch logic
     * @param entityTypesAttributesToPatch
     * @return EntityTypeAttribute[]
     */
    updateEntityTypeAttributesAsync(entityTypesAttributesToPatch: Map<string, any>): Promise<EntityTypeAttribute[]>;
    /**
     * this service returns all the data (properties, attributes and operations)
     * of a given entity type (by entity name)
     * @param entityTypeName
     */
    getAllEntityTypeDataByName(entityTypeName: string): Promise<EntityType>;
    /**
     * this service returns an array of elements
     * of the entity sent as a parameter,
     *  based on the filter it receives as a parameter.
     * @param entityTypeName
     * @param FilterGroup
     */
    getEntityTypeElements(entityTypeName: string, filterGroup: FilterGroup): Promise<PaginationResponse>;
    /**
     * Get all properties and attributes by entity type id
     * @param {string} entityTypeId
     * @returns {Promise<EntityTypeProperty[]>}
     */
    getAllPropertiesAndAttributesByEntityTypeIdAsync(entityTypeId: string): Promise<EntityTypeProperty[]>;
    /**
     * This service return a element from a entity type list by id
     * @param entityTypeName
     * @param elementId
     */
    getEntityTypeElementById(entityTypeName: string, elementId: string): Promise<any>;
    /**
     * this service excute an operation
     * @param entityName
     * @param operation
     * @param entity
     * @returns
     */
    executeAction(entityName: string, operation: EntityTypeOperation, entity: any): Promise<any>;
    /**
     * operations save product
     * @param element
     * @returns
     */
    private saveOperationProduct;
    /**
     * operation delte product
     * @param element
     * @returns
     */
    private deleteOperationProduct;
    /**
     *  operation update product
     * @param element
     * @returns
     */
    private updateOperationProduct;
    static ɵfac: i0.ɵɵFactoryDeclaration<MockEntityTypesService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<MockEntityTypesService>;
}
