import { OnDestroy, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { LazyLoadEvent } from 'primeng/api';
import { DialogService, DynamicDialogRef } from 'primeng/dynamicdialog';
import { Table } from 'primeng/table';
import { Subscription } from 'rxjs';
import { ReferenceType } from '../../../core/components/dynamic-form/models/constants/reference-type';
import { PrimeNgTypeToOurTypes } from '../../../core/models/filters';
import { TableConfigs } from '../../../core/models/table-configs';
import { PrimengUtilityService } from '../../../core/services/utility/primeng-utility.service';
import { EntityType } from '../../models/entity-type.model';
import { PrgEntityTypesConfig } from '../../models/prg-entity-types-config';
import { AbstractEntityTypeService } from '../../services/entity-types/abstract-entity-type.service';
import * as i0 from "@angular/core";
/**
 * list specific entity type elemens
 */
export declare class PrgListSpecificEntityTypeComponent implements OnInit, OnDestroy {
    private entityTypeService;
    private dialogService;
    private prgEntityTypesConfig;
    private primengUtilityService;
    private translateService;
    private router;
    /**
     * table view child
     */
    dataTableComponent: Table;
    /**
     * this input receives the entity type to be listed
     */
    entityTypeName: string;
    onClickGoTo: string;
    /**
     * entity type data
     */
    entityType: EntityType;
    /**
     * entity type elemens
     */
    entityTypeAllElements: any[];
    /**
     * entity groups
     */
    entityGroups: any[];
    /**
     * lazy loading are loading data
     */
    loading: boolean;
    /**
     * total elements that can be listed
     */
    totalRecords: number;
    /**
     * auxiliar primeNgTypeToOurTypes enum
     */
    primeNgTypeToOurTypes: typeof PrimeNgTypeToOurTypes;
    /**
     * auxiliar ReferenceType enum
     */
    ReferenceType: typeof ReferenceType;
    /**
     * dialog ref
     */
    elementRef: DynamicDialogRef;
    /**
     * selected columns objects data
     */
    selectedColumnsObject: any[];
    /**
     * table configs
     */
    tableConfigs: TableConfigs;
    /**
     * A class property used to unsubscribe observables on ngOnDestroy
     */
    subscription: Subscription[];
    /**
     * glabal filter is active
     */
    globalFilterIsActive: boolean;
    /**
     * global filtar diabled
     */
    globalFilterDisabled: boolean;
    /**
     * global filter value
     */
    globalFilterValue: string;
    /**
     * filter group
     */
    private filterGroup;
    /**
     * this variable serves to get the translation
     * label to put in the column select (directly in html doesn't work)
     */
    columnsSelectedLabel: string;
    /**
     * constructor
     *
     * @param entityTypeService
     * @param lookupTableService
     * @param dialogService
     * @param prgEntityTypesConfig
     * @param primengUtilityService
     * @param translateService
     * @param router
     */
    constructor(entityTypeService: AbstractEntityTypeService, dialogService: DialogService, prgEntityTypesConfig: PrgEntityTypesConfig, primengUtilityService: PrimengUtilityService, translateService: TranslateService, router: Router);
    /**
     * ngOnInit
     */
    ngOnInit(): Promise<void>;
    /**
     * ngOnDestroy
     *
     * Unsubscribe all subscriptions
     */
    ngOnDestroy(): void;
    /**
     * this function is executed every time
     * there is a change in the table's settings (pagination filters, etc)
     * @param event
     */
    lazyLoadElements(event: LazyLoadEvent): Promise<void>;
    /**
     * this function make an reset to table
     */
    clearAllFilters(): void;
    /**
     * open popup to edit or create an element
     * @param element
     */
    editElement(event: any, onPopup: boolean, element: any): void;
    /**
     * this function is responsible for opening the popup or
     * redirect to the page to be created a new element
     */
    addNewElement(onPopup: boolean): void;
    /**
     * this function is used when we have a custom filter,
     * and the value is a lookuptable, when we click on apply
     * we don't have the value set in the filters,
     * and I do this setter here, it just allows to have a search(not add option a and b)
     * @param value
     * @param field
     * @param matchMode
     */
    lookupTableFilterChange(value: any, field: string, matchMode: string): void;
    /**
     * get columns object by columns name in table configs
     */
    private getColumnsData;
    /**
     * create multiselect groups
     */
    private groupPropertyAndAttributesToColumnsSelect;
    /**
     * this function makes the request to get the data to be showed in the table
     */
    private getTableData;
    /**
     * this is an auxiliary function to check
     * if any of the table's filters are active
     * @param filters
     * @returns
     */
    private checkIfHaveColumnFilter;
    /**
     * this function calls the service that receives
     * the event (LazyLoadEvent) and creates a filterGroup
     * @param event
     * @returns
     */
    private createFilterGroup;
    /**
     * this function is responsible for creating
     *  the popup to edit or add an element
     * @param element
     * @param viewMode
     */
    private elementOnPopUp;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgListSpecificEntityTypeComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgListSpecificEntityTypeComponent, "prg-list-specific-entity-type", never, { "entityTypeName": "entityTypeName"; "onClickGoTo": "onClickGoTo"; }, {}, never, never, false>;
}
