import { OnDestroy, OnInit } from '@angular/core';
import { TreeNode } from 'primeng/api';
import { DialogService, DynamicDialogRef } from 'primeng/dynamicdialog';
import { BaseField } from '../../../core/components/dynamic-form/models/base-field';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { EntityType } from '../../models/entity-type.model';
import { PrgEntityTypesConfig } from '../../models/prg-entity-types-config';
import { AbstractEntityTypeService } from '../../services/entity-types/abstract-entity-type.service';
import * as i0 from "@angular/core";
/**
 * component List entity types
 */
export declare class PrgListEntityTypesComponent implements OnInit, OnDestroy {
    private entityTypeService;
    private arrayUtilityService;
    private prgEntityTypesConfig;
    dialogService: DialogService;
    private objectsUtilityService;
    /**
     * tree data
     */
    treeData: TreeNode[];
    /**
     * table columns
     */
    tableEntityTypeColumns: BaseField[];
    /**
     * subscriptions
     */
    private subscriptions;
    /**
     * property name to group
     */
    private readonly GROUP_BY_PROPERTY_NAME;
    /**
     * constructor
     * @param entityTypeService
     * @param arrayUtilityService
     * @param prgEntityTypesConfig
     * @param dialogService dialogService
     * @param objectsUtilityService
     */
    constructor(entityTypeService: AbstractEntityTypeService, arrayUtilityService: ArrayUtilityService, prgEntityTypesConfig: PrgEntityTypesConfig, dialogService: DialogService, objectsUtilityService: ObjectsUtilityService);
    /**
     * dialog ref
     */
    ref: DynamicDialogRef;
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * ngOnDestroy
     */
    ngOnDestroy(): void;
    /**
     * this function is responsible for generating and sending the necessary data to the dialog
     * @param entityType
     */
    showEntityTypeData(entityType: EntityType): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgListEntityTypesComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgListEntityTypesComponent, "prg-list-entity-types", never, {}, {}, never, never, false>;
}
