import { OnInit } from '@angular/core';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { BaseAction, DynamicFormActionOutput } from '../../../../../core/components/dynamic-form/models/base-action';
import { BaseField } from '../../../../../core/components/dynamic-form/models/base-field';
import { ViewMode } from '../../../../../core/models/constants/view-mode.enum';
import { NotificationsService } from '../../../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../../../core/services/utility/utility.service';
import { EntityType } from '../../../../models/entity-type.model';
import { AbstractEntityTypeService } from '../../../../services/entity-types/abstract-entity-type.service';
import { MenuTab } from './models/menu-tab.module';
import * as i0 from "@angular/core";
/**
 * entity type configuration component
 */
export declare class PrgEntityTypeConfigsComponent implements OnInit {
    private entityTypeService;
    private config;
    private ref;
    private notificationsService;
    private arrayUtilityService;
    private objectsUtilityService;
    private utilityService;
    /**
     * constructor
     * @param entityTypeService
     * @param config
     * @param ref
     * @param notificationsService
     * @param arrayUtilityService
     * @param objectsUtilityService
     * @param utilityService
     */
    constructor(entityTypeService: AbstractEntityTypeService, config: DynamicDialogConfig, ref: DynamicDialogRef, notificationsService: NotificationsService, arrayUtilityService: ArrayUtilityService, objectsUtilityService: ObjectsUtilityService, utilityService: UtilityService);
    /**
     * entity type
     */
    entityType: EntityType;
    /**
     * manu tab items
     */
    menuTabItems: MenuTab[];
    /**
     * tab active item
     */
    activeItem: MenuTab;
    /**
     * elements list (properties, attributes, operations)
     */
    elements: any[];
    /**
     * element selected
     */
    elementsSelected: any[];
    /**
     * entity type form fields
     */
    entityTypeDynamicFormFields: BaseField[];
    /**
     * entity type form actions
     */
    entityTypeDynamicFormActions: BaseAction[];
    /**
     * elements form fields (default is fields from properties)
     */
    elementDynamicFormFields: BaseField[];
    /**
     * elements form actions
     */
    elementDynamicFormActions: BaseAction[];
    /**
     * entity type view mode
     */
    entityTypeViewMode: ViewMode;
    /**
     * elements view mode
     */
    elementViewMode: ViewMode;
    /**
     * diabled list
     */
    disabledList: boolean;
    /**
     * debounce time
     */
    private debounceTime;
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * this function receives the event
     * when a new element is selected in the list
     * @param event
     * @returns
     */
    onSelectionChanged(event: any): void;
    /**
     * this function receives the output referring to the actions of an entity
     * type and in function of the received action performs the corresponding actions
     * @param event
     */
    onEntityTypeActionOutputted(event: DynamicFormActionOutput): Promise<void>;
    /**
     * this function is responsible for receiving the changes from the selected tab and loading the respective data
     * @param event
     */
    tabChange(event: MenuTab): void;
    /**
     * this function manages the status of the
     * tabs according to the parameters
     * it can activate or deactivate all tabs as well
     * as change the status of a single tab
     *
     * @param menuTabItem
     * @param status
     */
    private menuTabsItemsManage;
    /**
     * create empty element, depending on the tab selected
     */
    private addNewElement;
    /**
     * this function loads the elements according to the tab selected,
     *  and changes the form's data
     */
    private loadElements;
    /**
     * this function receives the output of an entity,
     * and treats each of the actions with the respective logic to be applied
     * @param event
     */
    onEntityActionOutputted(event: DynamicFormActionOutput): void;
    /**
     * this function is responsible for saving the new element added,
     * depending on the selected tab it calls the respective method
     * @param newElement
     */
    private saveNewElement;
    /**
     * this function is responsible for updating
     * the elements in the database when they have their order changed
     */
    reorderElements: (args?: any) => void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgEntityTypeConfigsComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgEntityTypeConfigsComponent, "prg-entity-type-configs", never, {}, {}, never, never, false>;
}
