import { OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { BaseAction, DynamicFormActionOutput } from '../../../core/components/dynamic-form/models/base-action';
import { BaseField } from '../../../core/components/dynamic-form/models/base-field';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import { EntityType } from '../../models/entity-type.model';
import { AbstractEntityTypeService } from '../../services/entity-types/abstract-entity-type.service';
import * as i0 from "@angular/core";
export declare class PrgEntityTypeElementComponent implements OnInit {
    private arrayUtilityService;
    private utilityService;
    private entityTypeService;
    private ref;
    private config;
    private objectsUtilityService;
    private notificationsService;
    private translateService;
    private router;
    private route;
    /**
     * element aux
     */
    private _element;
    /**
     * element input
     */
    set element(element: any);
    /**
     * element getter
     */
    get element(): any;
    /**
     * entity type aux
     */
    private _entityType;
    /**
     * entity type input
     */
    set entityType(entityType: EntityType);
    /**
     * entity type getter
     */
    get entityType(): EntityType;
    /**
     * entity type view mode
     */
    elementViewMode: ViewMode;
    /**
     * entity type form fields
     */
    entityTypeDynamicFormElementFields: BaseField[];
    /**
     * entity type form actions
     */
    entityTypeDynamicFormElementActions: BaseAction[];
    /**
     * variable to save if is a popup
     */
    private isPopup;
    /**
     * constructor
     *
     * @param arrayUtilityService
     * @param utilityService
     * @param entityTypeService
     * @param ref
     * @param config
     * @param objectsUtilityService
     */
    constructor(arrayUtilityService: ArrayUtilityService, utilityService: UtilityService, entityTypeService: AbstractEntityTypeService, ref: DynamicDialogRef, config: DynamicDialogConfig, objectsUtilityService: ObjectsUtilityService, notificationsService: NotificationsService, translateService: TranslateService, router: Router, route: ActivatedRoute);
    /**
     * ngOnInit
     *
     *  if this component is contained in a dialog it fetches the data from the config
     */
    ngOnInit(): void;
    /**
     * this function receives the output and depending on
     * the action clicked performs a certain set of actions
     *
     * @param event
     */
    onActionOutputed(event: DynamicFormActionOutput): Promise<void>;
    /**
     * this function creates the filds for the dynamic
     * form according to the properties of an entity type
     * @param entityType
     */
    private getBaseFieldsFromEntityType;
    /**
     * this function creates the actions depending
     * on the operations associated to a given entity type
     *
     * @param entityTypeOperations
     */
    private getActionsFromEntityType;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgEntityTypeElementComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgEntityTypeElementComponent, "prg-entity-type-element", never, { "element": "element"; "entityType": "entityType"; "elementViewMode": "elementViewMode"; }, {}, never, never, false>;
}
