import { HttpClient } from '@angular/common/http';
import { Dashboard } from '../../models/dashboard.model';
import { AbstractDashboardService } from './abstract-dashboard.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class DashboardService extends AbstractDashboardService {
    private httpClient;
    /**
     * Constructor
     * @param {HttpClient} httpClient
     */
    constructor(httpClient: HttpClient);
    /**
     * Function responsible to store a new Dashboard
     * @param {Dashboard} newDashboard
     * @returns {Promise<Dashboard>}
     */
    createDashboardAsync(newDashboard: Dashboard): Promise<Dashboard>;
    /**
     * Get dashboard by Id
     * @param {string} dashboardId
     * @returns {Promise<Dashboard>}
     */
    getDashboardByIdAsync(dashboardId: string): Promise<Dashboard>;
    /**
     * Function responsible to update a dashboard
     * @param {string} dashboardId
     * @param {Dashboard} dashboard
     * @returns {Promise<Dashboard>}
     */
    updateDashboardAsync(dashboardId: string, dashboard: Dashboard): Promise<Dashboard>;
    /**
     * Get dashboards by User Logged
     * @returns {Promise<Dashboard[]>}
     */
    getDashboardsByUserAsync(): Promise<Dashboard[]>;
    static ɵfac: i0.ɵɵFactoryDeclaration<DashboardService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<DashboardService>;
}
