import { HttpClient } from '@angular/common/http';
import { GridsterItemComponentInterface } from 'angular-gridster2';
import { BehaviorSubject, Observable } from 'rxjs';
import { Dashboard } from '../../models/dashboard.model';
import { PrgGridsterConfig, PrgGridsterItem } from '../../models/prg-gridster-config';
/**
 * AbstractQueriesService class that defines an
 * <br />abstract dashboard service to
 * <br />be extended by the mock and real
 * <br />dashboard services
 */
export declare abstract class AbstractDashboardService {
    private http;
    /**
     * Constructor
     * @param {HttpClient} http
     */
    constructor(http: HttpClient);
    /**
     * Detect changes on dashboard options made on prg-dashboard-options.component
     */
    protected dashboardOptionsChangesSubject: BehaviorSubject<GridConfigsAndItems>;
    /**
     * Detect changes on the size of dashboardItems
     * @type {BehaviorSubject<GridsterItemComponentInterface>}
     * @protected
     */
    protected dashboardItemsResizeSubject: BehaviorSubject<GridsterItemComponentInterface>;
    /**
     * Detect changes on the list of dashboards
     * @type {BehaviorSubject<Dashboard[]>}
     * @protected
     */
    protected dashboardListUpdatedSubject: BehaviorSubject<Dashboard[]>;
    /**
     * Setter for dashboardOptionsChangesSubject
     * @param {GridConfigsAndItems} value
     */
    setDashboardOptionsChanges(value: GridConfigsAndItems): void;
    /**
     * Getter for dashboardOptionsChangesSubject
     * @returns {Observable<GridConfigsAndItems>}
     */
    getDashboardOptionsChangesObservable(): Observable<GridConfigsAndItems>;
    /**
     * Getter for dashboardOptionsChangesSubject
     * @returns {GridConfigsAndItems}
     */
    getDashboardOptionsChangesValue(): GridConfigsAndItems;
    /**
     * Setter for dashboardItemsResizeSubject
     * @param {GridsterItemComponentInterface} value
     */
    setDashboardItemsResize(value: GridsterItemComponentInterface): void;
    /**
     * Getter for dashboardItemsResizeSubject
     * @returns {Observable<GridsterItemComponentInterface>}
     */
    getDashboardItemsResizeObservable(): Observable<GridsterItemComponentInterface>;
    /**
     * Getter for dashboardItemsResizeSubject
     * @returns {GridsterItemComponentInterface}
     */
    getDashboardItemsResizeValue(): GridsterItemComponentInterface;
    /**
     * Setter for dashboardListUpdatedSubject
     * @param {Dashboard[]} value
     */
    protected setDashboardListUpdated(value: Dashboard[]): void;
    /**
     * Getter for dashboardListUpdatedSubject
     * @returns {Observable<Dashboard[]>}
     */
    getDashboardListUpdatedObservable(): Observable<Dashboard[]>;
    /**
     * Getter for dashboardListUpdatedSubject
     * @returns {Dashboard[]}
     */
    getDashboardListUpdatedValue(): Dashboard[];
    /**
     * Function responsible to store a new Dashboard
     * @param {Dashboard} newDashboard
     * @returns {Promise<Dashboard>}
     */
    abstract createDashboardAsync(newDashboard: Dashboard): Promise<Dashboard>;
    /**
     * Get dashboard by Id
     * @param {string} dashboardId
     * @returns {Promise<Dashboard>}
     */
    abstract getDashboardByIdAsync(dashboardId: string): Promise<Dashboard>;
    /**
     * Get dashboards by User Logged
     * @returns {Promise<Dashboard[]>}
     */
    abstract getDashboardsByUserAsync(): Promise<Dashboard[]>;
    /**
     * Function responsible to update a dashboard
     * @param {string} dashboardId
     * @param {Dashboard} dashboard
     * @returns {Promise<Dashboard>}
     */
    abstract updateDashboardAsync(dashboardId: string, dashboard: Dashboard): Promise<Dashboard>;
}
export declare type GridConfigsAndItems = {
    gridsterConfig: PrgGridsterConfig;
    gridsterItems: PrgGridsterItem[];
};
