import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * Enum for dynamic components to be used on dashboards
 */
export declare enum ComponentTypeEnum {
    BarChart = "Bar-Chart",
    LineChart = "Line-Chart",
    DoughnutChart = "Doughnut-Chart",
    Table = "Table"
}
/**
 * Map name of componentType to classes
 */
export declare const MapComponentTypesToClass: Map<string, any>;
/**
 * Dashboard Class
 */
export declare class Dashboard extends BaseEntity {
    /**
     * Complete path for configuration items tree
     * @type {string}
     */
    path: string;
    /**
     * Read only
     * @type {boolean}
     */
    isPublic: boolean;
    /**
     * An array of entity types
     * @type {string[]}
     */
    entityTypeIds: string[];
    /**
     * Settings of the dashboard
     * @type {string}
     */
    settings: string;
    /**
     * The items of dashboard
     * @type {DashboardItem[]}
     */
    items: DashboardItem[];
    /**
     * Cosntructor
     * @param {Partial<Dashboard>} init
     */
    constructor(init?: Partial<Dashboard>);
}
/**
 * Dashboard Items CLass
 */
export declare class DashboardItem extends BaseEntity {
    /**
     *  number of columns in of the item on dashboard
     * @type {number}
     */
    cols: number;
    /**
     * number of rows in of the item on dashboard
     * @type {number}
     */
    rows: number;
    /**
     * x position in dashboard
     * @type {number}
     */
    x: number;
    /**
     *  y position in dashboard
     * @type {number}
     */
    y: number;
    /**
     * Component type
     * @type {string}
     */
    componentType: string;
    /**
     * Dashboard Id
     * @type {string}
     */
    dashboardId: string;
    /**
     * Override GuiSettings settings of componentType
     * @type {string}
     */
    settings: string;
    /**
     * Constructor
     * @param {Partial<DashboardItem>} init
     */
    constructor(init?: Partial<DashboardItem>);
}
/**
 * Component Type Class
 */
export declare class ComponentType extends BaseEntity {
    /**
     * Gui Settings
     * @type {string}
     */
    generalSettings: any;
    /**
     * Image of Component type
     * @type {string}
     */
    imageUrl: string;
    /**
     * Type of component
     * @type {ComponentTypeEnum}
     */
    type: ComponentTypeEnum;
    /**
     * Label for translation purpose
     * @type {string}
     */
    label: string;
    /**
     * Constructor
     * @param {Partial<DashboardItem>} init
     */
    constructor(init?: Partial<ComponentType>);
}
