import { HttpClient } from '@angular/common/http';
import { AbstractAuthService } from '../../../auth/services/auth/abstract-auth.service';
import { IsLoadingDataService } from '../../../core/services/is-loading-data/isloadingdata.service';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import { Dashboard } from '../../models/dashboard.model';
import { AbstractDashboardService } from '../../services/dashboard/abstract-dashboard.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class MockDashboardService extends AbstractDashboardService {
    private notificationsService;
    private utilityService;
    private isLoadingData;
    private objectsUtilityService;
    private arrayUtilityService;
    private authService;
    private httpClient;
    /**
     * default time in seconds
     */
    private sleepTimeSec;
    /**
     * Constructor
     * @param {NotificationsService} notificationsService
     * @param {UtilityService} utilityService
     * @param {IsLoadingDataService} isLoadingData
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {AbstractAuthService} authService
     * @param {HttpClient} httpClient
     */
    constructor(notificationsService: NotificationsService, utilityService: UtilityService, isLoadingData: IsLoadingDataService, objectsUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, authService: AbstractAuthService, httpClient: HttpClient);
    /**
     * Function responsible to store a new Dashboard
     * @param {Dashboard} newDashboard
     * @returns {Promise<Dashboard>}
     */
    createDashboardAsync(newDashboard: Dashboard): Promise<Dashboard>;
    /**
     * Get Dashboard by Id
     * @param {string} dashboardId
     * @returns {Promise<Dashboard>}
     */
    getDashboardByIdAsync(dashboardId: string): Promise<Dashboard>;
    /**
     * Function responsible to update a dashboard
     * @param {string} dashboardId
     * @param {Dashboard} dashboard
     * @returns {Promise<Dashboard>}
     */
    updateDashboardAsync(dashboardId: string, dashboard: Dashboard): Promise<Dashboard>;
    /**
     * Get dashboards by User Logged
     * @returns {Promise<Dashboard[]>}
     */
    getDashboardsByUserAsync(): Promise<Dashboard[]>;
    static ɵfac: i0.ɵɵFactoryDeclaration<MockDashboardService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<MockDashboardService>;
}
