import { LocationStrategy } from '@angular/common';
import { OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { GridsterComponent } from 'angular-gridster2';
import { DialogService } from 'primeng/dynamicdialog';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import { MainLayoutService } from '../../../layouts/services/main-layout.service';
import { ComponentType, Dashboard } from '../../models/dashboard.model';
import { PrgDashboardConfig } from '../../models/prg-dashboard-config';
import { PrgGridsterConfig, PrgGridsterItem } from '../../models/prg-gridster-config';
import { AbstractDashboardService } from '../../services/dashboard/abstract-dashboard.service';
import * as i0 from "@angular/core";
/**
 * Dashboard Component
 */
export declare class PrgDashboardComponent implements OnInit, OnDestroy {
    dialogService: DialogService;
    private mainLayoutService;
    private objectsUtilityService;
    private arrayUtilityService;
    private dashboardService;
    private utilityService;
    private route;
    private router;
    private prgDashboardConfig;
    private location;
    private notificationsService;
    private translateService;
    /**
     * The dynamic form fields to build dashboard form in template
     */
    dashboardDynamicFormFields: any[];
    /**
     * The view mode for dynamic form
     * @type {ViewMode}
     */
    dashboardViewMode: ViewMode;
    /**
     * The current dashboard
     * @type {Dashboard}
     */
    dashboard: Dashboard;
    /**
     * The current state of sidebar menu. Expanded is true and collapsed is false.
     *
     * Default is false.
     * @type {boolean}
     */
    menuDashboardExpanded: boolean;
    /**
     * The id of dashboard get it from url parameter
     * @type {string}
     */
    idDashboard: string;
    /**
     * An array of component type list to be shown on sidebar
     * @type {any[]}
     */
    componentsType: any[];
    /**
     * The current component type selected
     * @type {any}
     */
    componentTypeSelected: any;
    /**
     * The base route for editing a dashboard
     * @type {string}
     */
    editDashboardPageRoute: string;
    /**
     * The dashboard settings object based on Gridster options
     * @type {PrgGridsterConfig}
     */
    dashboardOptions: PrgGridsterConfig;
    /**
     * An array of widgets (dynamic items) displayed on dashboard
     * @type {Array<PrgGridsterItem>}
     */
    dashboardItems: Array<PrgGridsterItem>;
    /**
     * A copy dashboard items
     * @type {Array<PrgGridsterItem>}
     * @private
     */
    private dashboardItemsCopy;
    /**
     * A class property used to unsubscribe observables on ngOnDestroy
     * @type {Subscription[]}
     * @private
     */
    private subscription;
    /**
     * A copy of dashboard
     * @type {Dashboard}
     * @private
     */
    private dashboardCopy;
    /**
     * Property of type DynamicDialogRef to control the dialog of dashboard options
     */
    private dynamicDialogRef;
    /**
     * Property of type DynamicDialogRef to control the dialog of items options
     */
    private dynamicDialogRefItems;
    /**
     * A copy of dashboard options
     * @type {PrgGridsterConfig}
     * @private
     */
    private dashboardOptionsCopy;
    /**
     * Constructor
     * @param {DialogService} dialogService dialogService
     * @param {MainLayoutService} mainLayoutService
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ActivatedRoute} route
     * @param {Router} router
     * @param {PrgDashboardConfig} prgDashboardConfig
     * @param {LocationStrategy} location
     * @param {NotificationsService} notificationsService
     * @param {TranslateService} translateService
     */
    constructor(dialogService: DialogService, mainLayoutService: MainLayoutService, objectsUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, dashboardService: AbstractDashboardService, utilityService: UtilityService, route: ActivatedRoute, router: Router, prgDashboardConfig: PrgDashboardConfig, location: LocationStrategy, notificationsService: NotificationsService, translateService: TranslateService);
    /**
     * ngOnInit
     *
     * Verify if there is any changes on size of main sidebar and update view on dashboard.
     *
     * Verify if there is any changes on Dashboard Options form and reflect them on the view of dashboard.
     *
     * Verify route and if there is a parameter on route, if of dashboard and if so set this as the selected dashboard
     * @returns {Promise<void>}
     */
    ngOnInit(): Promise<void>;
    /**
     * This function will populate components type list on sidebar
     * @private
     */
    private populateComponentsType;
    /**
     * Setting up a new dashboard
     * @returns {Promise<void>}
     * @private
     */
    private setNewDashboardSettings;
    /**
     * This function will get and set the dashboard selected on list
     * @returns {Promise<void>}
     * @private
     */
    private getDashboard;
    /**
     * Setting up items for dashboard
     * @private
     */
    private setDashboardItems;
    /**
     * Setting up call back for dashboard
     * @private
     */
    private settingCallBackFunctionDashboard;
    /**
     * This function is responsible to delete an item of dashboard
     * @param {MouseEvent} event
     * @param {PrgGridsterItem} item
     */
    onDeleteItem(event: MouseEvent, item: PrgGridsterItem): void;
    /**
     * This function is responsible to refresh grid options
     * @private
     */
    private changedOptions;
    /**
     * This function will add an item on the first possible position of the dashboard
     * @param {ComponentType} componentType
     */
    onAddItemFirstPossiblePosition(componentType?: ComponentType): void;
    /**
     * This function is responsible to clear all items of dashboard
     * @returns {Promise<void>}
     */
    clearAllItems(): Promise<void>;
    /**
     * ngOnDestroy
     *
     * Unsubscribe subscriptions
     */
    ngOnDestroy(): void;
    /**
     * This function will add an item on an empty cell that was clicked
     * @param {MouseEvent} event
     * @param {PrgGridsterItem} item
     * @private
     */
    private emptyCellClick;
    /**
     * This function is responsible to open dashboard options modal and handle actions when it closes
     */
    openOptionsDashboard(): void;
    /**
     *  This function will save the dashboard
     * @param entity
     * @returns {Promise<void>}
     */
    saveDashboard(entity: any): Promise<void>;
    /**
     * This function is auxiliary function of saveDashboard. Prepares dashboard items to be saved.
     * @private
     */
    private prepareDashboardItemsToSave;
    /**
     * This function is call whenever height or width of each item changes
     * @param {PrgGridsterItem} item
     * @param {GridsterItemComponentInterface} itemComponent
     * @private
     */
    private onItemChangeSized;
    /**
     * This function is call when a drag occurs on dashboard.Set componentTypeSelected.
     * @param componentType
     */
    onDragItem(componentType: any): void;
    /**
     * This function is responsible to handle actions after an item was drop in an empty cell on the dashboard
     * @param event
     * @param {GridsterComponent} gridsterComponent
     */
    onDropItemEmptyCell(event: any, gridsterComponent: GridsterComponent): void;
    /**
     * This function is responsible to handle actions after an item was drop in an occupied cell on the dashboard
     * @param event
     * @param {PrgGridsterItem} item
     * @param {GridsterComponent} gridsterComponent
     * @constructor
     */
    OnDropItem(event: any, item: PrgGridsterItem, gridsterComponent: GridsterComponent): void;
    /**
     * This function is call whenever sidebar expands or collapses
     */
    onShowHideSideBarDetails(): void;
    /**
     * This function is responsible to open dashboard items options modal and handle actions when it closes
     * @param {PrgGridsterItem} item
     */
    onOpenItemOptions(item: PrgGridsterItem): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgDashboardComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgDashboardComponent, "prg-dashboard", never, { "editDashboardPageRoute": "editDashboardPageRoute"; }, {}, never, never, false>;
}
