import { OnInit } from '@angular/core';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { DynamicFormActionOutput, DynamicFormFieldChangeOutput } from '../../../core/components/dynamic-form/models/base-action';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { AbstractDashboardService } from '../../services/dashboard/abstract-dashboard.service';
import * as i0 from "@angular/core";
/**
 * Dashboard Options Component
 */
export declare class PrgDashboardOptionsComponent implements OnInit {
    private arrayUtilityService;
    private dynamicDialogRef;
    private dynamicDialogConfig;
    private objectsUtilityService;
    private dashboardService;
    /**
     * The view mode for dynamic form
     * @type {ViewMode}
     */
    dashboardOptionsViewMode: ViewMode;
    /**
     * The dynamic form fields to build dynamic dashboard options form in template
     */
    dashboardOptionsDynamicFormFields: any[];
    /**
     * The dynamic form actions to build dynamic dashboard options form  in template
     */
    dashboardOptionsDynamicFormActions: any[];
    /**
     * The dashboard settings object flatten object based on Gridster options
     * @type {any}
     */
    dashboardOptionsFlatten: any;
    /**
     * The dashboard settings object based on Gridster options
     * @type {PrgGridsterConfig}
     * @private
     */
    private dashboardOptions;
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {DynamicDialogRef} dynamicDialogRef
     * @param {DynamicDialogConfig} dynamicDialogConfig
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {AbstractDashboardService} dashboardService
     */
    constructor(arrayUtilityService: ArrayUtilityService, dynamicDialogRef: DynamicDialogRef, dynamicDialogConfig: DynamicDialogConfig, objectsUtilityService: ObjectsUtilityService, dashboardService: AbstractDashboardService);
    /**
     * ngOnInit
     *
     * Get the data from parent component
     */
    ngOnInit(): void;
    /**
     * This function is responsible to handle actions from the dynamic form
     * @param {DynamicFormActionOutput} event
     */
    actionOutput(event: DynamicFormActionOutput): void;
    /**
     * This function is called whenever is a change on a field and emit a new value for DashboardOptionsChangesSubject
     * @param {DynamicFormFieldChangeOutput} event
     */
    fieldChanges(event: DynamicFormFieldChangeOutput): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgDashboardOptionsComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgDashboardOptionsComponent, "prg-dashboard-options", never, {}, {}, never, never, false>;
}
