import { HttpClient } from '@angular/common/http';
import { OnDestroy, OnInit } from '@angular/core';
import { ObjectsUtilityService } from '../../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../../core/services/utility/utility.service';
import { MainLayoutService } from '../../../../layouts/services/main-layout.service';
import { AbstractDashboardService } from '../../../services/dashboard/abstract-dashboard.service';
import { BaseDashboardComponent } from '../base-dashboard-component';
import * as i0 from "@angular/core";
/**
 * Table Component
 */
export declare class PrgTableComponent extends BaseDashboardComponent implements OnInit, OnDestroy {
    private http;
    private mainLayoutService;
    private dashboardService;
    private utilityService;
    private objectsUtilityService;
    /**
     *  Data for this table
     * @type {any}
     */
    products: Product[];
    /**
     * Height of the chart
     * @type {string}
     */
    height: string;
    /**
     * Width of the chart
     * @type {string}
     */
    width: string;
    /**
     * The item id used on dashboard
     */
    itemId: any;
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings: any);
    /**
     * aux settings
     * @private
     */
    private _itemSettings;
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings(): any;
    /**
     * A class property used to unsubscribe observables on ngOnDestroy
     * @type {Subscription[]}
     * @private
     */
    private subscription;
    /**
     * Constructor
     * @param {HttpClient} http
     * @param {MainLayoutService} mainLayoutService
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(http: HttpClient, mainLayoutService: MainLayoutService, dashboardService: AbstractDashboardService, utilityService: UtilityService, objectsUtilityService: ObjectsUtilityService);
    /**
     * ngOnInit
     * @returns {Promise<void>}
     */
    ngOnInit(): Promise<void>;
    /**
     * ngOnDestroy
     */
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgTableComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgTableComponent, "prg-table", never, { "itemId": "itemId"; "itemSettings": "itemSettings"; }, {}, never, never, false>;
}
/**
 * Product Interface used to test table component
 */
export interface Product {
    /**
     * id
     */
    id?: string;
    /**
     * code
     */
    code?: string;
    /**
     * name
     */
    name?: string;
    /**
     * description
     */
    description?: string;
    /**
     * price
     */
    price?: number;
    /**
     * quantity
     */
    quantity?: number;
    /**
     * inventoryStatus
     */
    inventoryStatus?: string;
    /**
     * category
     */
    category?: string;
    /**
     * image
     */
    image?: string;
    /**
     * rating
     */
    rating?: number;
}
