import { OnDestroy, OnInit } from '@angular/core';
import { UIChart } from 'primeng/chart';
import { ObjectsUtilityService } from '../../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../../core/services/utility/utility.service';
import { AbstractDashboardService } from '../../../services/dashboard/abstract-dashboard.service';
import { BaseDashboardComponent } from '../base-dashboard-component';
import * as i0 from "@angular/core";
/**
 * Line Chart Component
 */
export declare class PrgLineChartComponent extends BaseDashboardComponent implements OnInit, OnDestroy {
    private dashboardService;
    private utilityService;
    private objectsUtilityService;
    /**
     *  Data for this chart
     * @type {any}
     */
    basicData: any;
    /**
     * Options for this chart
     * @type {any}
     */
    basicOptions: any;
    /**
     * Height of the chart
     * @type {string}
     */
    height: string;
    /**
     * Width of the chart
     * @type {string}
     */
    width: string;
    /**
     * The item id used on dashboard
     */
    itemId: any;
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings: any);
    /**
     * aux settings
     * @private
     */
    private _itemSettings;
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings(): any;
    /**
     * The chart element from template
     * @type {UIChart}
     */
    chart: UIChart;
    /**
     * A class property used to unsubscribe observables on ngOnDestroy
     * @type {Subscription[]}
     * @private
     */
    private subscription;
    /**
     * Constructor
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(dashboardService: AbstractDashboardService, utilityService: UtilityService, objectsUtilityService: ObjectsUtilityService);
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * ngOnDestroy
     */
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgLineChartComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgLineChartComponent, "prg-line-chart", never, { "itemId": "itemId"; "itemSettings": "itemSettings"; }, {}, never, never, false>;
}
