import { OnInit } from '@angular/core';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { BaseAction, DynamicFormActionOutput } from '../../../core/components/dynamic-form/models/base-action';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import * as i0 from "@angular/core";
/**
 * Dashboard Items Options Component
 */
export declare class PrgDashboardItemsOptionsComponent implements OnInit {
    private objectsUtilityService;
    private arrayUtilityService;
    private dynamicDialogRef;
    private dynamicDialogConfig;
    private utilityService;
    /**
     * The dynamic form fields to build dashboard items form in template
     */
    dashboardItemsOptionsDynamicFormFields: any[];
    /**
     * The dynamic form actions to build dashboard items form in template
     */
    dashboardItemsOptionsDynamicFormActions: BaseAction[];
    /**
     * The view mode for dynamic form
     * @type {ViewMode}
     */
    dashboardItemsOptionsViewMode: ViewMode;
    /**
     * The dashboard item settings to be used on the form (entity)
     */
    dashboardItemSettings: any;
    /**
     * The dashboard widget (dynamic component) to be edited
     * @type {PrgGridsterItem}
     * @private
     */
    private dashboardItem;
    /**
     * The index of dashboard item on the array of items
     * @type {number}
     * @private
     */
    private index;
    /**
     * Constructor
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {DynamicDialogRef} dynamicDialogRef
     * @param {DynamicDialogConfig} dynamicDialogConfig
     * @param {UtilityService} utilityService
     */
    constructor(objectsUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, dynamicDialogRef: DynamicDialogRef, dynamicDialogConfig: DynamicDialogConfig, utilityService: UtilityService);
    /**
     * ngOnInit
     *
     * Get the data from parent component
     */
    ngOnInit(): void;
    /**
     * This function is responsible to handle actions from the dynamic form
     * @param {DynamicFormActionOutput} event
     */
    actionOutput(event: DynamicFormActionOutput): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgDashboardItemsOptionsComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgDashboardItemsOptionsComponent, "prg-dashboard-items-options", never, {}, {}, never, never, false>;
}
