import { LocationStrategy } from '@angular/common';
import { OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { ArrayUtilityService } from '../../../core/services/utility/array-utility.service';
import { ObjectsUtilityService } from '../../../core/services/utility/objects-utility.service';
import { UtilityService } from '../../../core/services/utility/utility.service';
import { MainLayoutService } from '../../../layouts/services/main-layout.service';
import { Dashboard } from '../../models/dashboard.model';
import { PrgGridsterConfig, PrgGridsterItem } from '../../models/prg-gridster-config';
import { AbstractDashboardService } from '../../services/dashboard/abstract-dashboard.service';
import * as i0 from "@angular/core";
/**
 * Display dashboard component
 */
export declare class PrgDashboardDisplayComponent implements OnInit, OnDestroy {
    private objectsUtilityService;
    private arrayUtilityService;
    private dashboardService;
    private utilityService;
    private route;
    private location;
    private mainLayoutService;
    /**
     * Show/hide header.Default is true.
     * @type {boolean}
     */
    displayHeader: boolean;
    /**
     * Show/hide dashboard selection dropdown.Default is true.
     * @type {boolean}
     */
    showDropdown: boolean;
    /**
     * The dashboard settings object based on Gridster options
     * @type {PrgGridsterConfig}
     */
    dashboardOptions: PrgGridsterConfig;
    /**
     * An array of widgets (dynamic items) displayed on dashboard
     * @type {Array<PrgGridsterItem>}
     */
    dashboardItems: Array<PrgGridsterItem>;
    /**
     * A list of all dashboard created by logged user
     * @type {Dashboard[]}
     */
    dashboardsByUser: Dashboard[];
    /**
     * Show/Hide dashboard on template.Default is false.
     * @type {boolean}
     */
    displayDashboard: boolean;
    /**
     * The current selected dashboard
     * @type {Dashboard}
     */
    selectedDashboard: Dashboard;
    /**
     * The name of dashboard selected
     * @type {string}
     */
    private nameDashboard;
    /**
     * A class property used to unsubscribe observables on ngOnDestroy
     * @type {Subscription[]}
     * @private
     */
    private subscription;
    /**
     * Constructor
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ActivatedRoute} route
     * @param {LocationStrategy} location
     * @param {MainLayoutService} mainLayoutService
     */
    constructor(objectsUtilityService: ObjectsUtilityService, arrayUtilityService: ArrayUtilityService, dashboardService: AbstractDashboardService, utilityService: UtilityService, route: ActivatedRoute, location: LocationStrategy, mainLayoutService: MainLayoutService);
    /**
     * ngOnInit
     *
     * Verify if there is any changes on size of main sidebar and update view on dashboard.
     *
     * Load all dashboard created by logged user.
     *
     * Verify if there is a parameter on route, name of dashboard and if so set this as the selected dashboard
     *
     * @returns {Promise<void>}
     */
    ngOnInit(): Promise<void>;
    /**
     * Setting up the dashboard selected
     * @returns {Promise<void>}
     * @private
     */
    private settingDashboard;
    /**
     * Setting up items for current dashboard selected
     * @private
     */
    private setDashboardItems;
    /**
     * Setting up call back functions and additional options for the current dashboard selected
     * @private
     */
    private settingCallBackFunctionDashboard;
    /**
     * This function is call whenever height or width of each item changes
     * @param {PrgGridsterItem} item
     * @param {GridsterItemComponentInterface} itemComponent
     * @private
     */
    private onItemChangeSized;
    /**
     * This function is responsible to refresh grid options
     * @private
     */
    private changedOptions;
    /**
     * This function is call when a dashboard is selected on dropdown
     * @param $event
     * @returns {Promise<void>}
     */
    onChangeDashboard($event: any): Promise<void>;
    /**
     * ngOnDestroy
     *
     * Unsubscribe  subscriptions and set the display header state to true
     */
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgDashboardDisplayComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgDashboardDisplayComponent, "prg-dashboard-display", never, { "displayHeader": "displayHeader"; "showDropdown": "showDropdown"; }, {}, never, never, false>;
}
