import { TreeNode } from 'primeng/api';
import { ArrayUtilityService } from './array-utility.service';
import { ObjectsUtilityService } from './objects-utility.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class UtilityService {
    private arrayUtilityService;
    private objectsUtilityService;
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(arrayUtilityService: ArrayUtilityService, objectsUtilityService: ObjectsUtilityService);
    /**
     * the default debounce time
     * @type {number}
     * @private
     */
    private defaultDebounceTime;
    /**
     * this function generate a string
     * @returns string
     */
    newGuid(): string;
    /**
     * this function make a timeout
     *
     * @param timeInMs
     * @returns Promise<void>
     */
    sleepMsAsync(timeInMs: number): Promise<void>;
    /**
     * this function make a timeout
     *
     * @param timeInSec
     * @returns Promise<void>
     */
    sleepSecAsync(timeInSec: number): Promise<void>;
    /**
     * Make eval of expression
     * @param {string} expression
     * @param context
     * @returns {any}
     */
    evalFunction(expression: string, ...context: any[]): any;
    /**
     * An auxiliary function to make a deeper copy of the object
     * @param obj
     * @returns {any}
     * @private
     */
    private shallowClone;
    /**
     * debounce function
     * @param func
     * @param wait
     * @param immediate
     * @returns
     */
    debounce(func: any, wait?: number, immediate?: boolean): (args?: any) => void;
    /**
     * this function transforms the guiSettings into an object,
     * even managing the validators if they exist
     * @param guiSettings
     * @param basePathTranslation
     * @returns
     */
    guiSettingToObject(guiSettings: string, basePathTranslation?: string): any;
    /**
     * This function build a tree structure to be used on primeng from a list of paths (array of strings) that
     * are joined with a separator ex: "[Configs:UserPreferences:Defaults,Configs:UserPreferences:User...]"
     * @param {string[]} arrayOfPaths
     * @param {string} separator
     * @returns {TreeNode[]}
     */
    arrayOfPathsToTree(arrayOfPaths: string[], separator: string): TreeNode[];
    /**
     * This function is responsible to search for a key in map by a given value
     * @param map
     * @param searchValue
     * @returns {any}
     */
    getKeyByValueOnMap(map: any, searchValue: any): any;
    static ɵfac: i0.ɵɵFactoryDeclaration<UtilityService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<UtilityService>;
}
