import { LazyLoadEvent } from 'primeng/api';
import { FilterExpressions, FilterGroup } from '../../models/filters';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class PrimengUtilityService {
    /**
     * this function is to calculate the index of the page we need to request
     * @param event
     * @returns
     */
    private calcPageIndex;
    /**
     * this function processes the filters coming from
     * the event thrown by primeng and returns
     *  a working filter array to our api
     * @param filters
     * @param globalFilterFields
     * @param globalFilterExpression
     * @returns Filter[]
     */
    private filtersProcessing;
    /**
     * this function creates a filter with the received parameters
     * @param filterValue
     * @param propertyName
     * @param filterExpression
     * @param filterOperation
     * @returns
     */
    private generateFilter;
    /**
     * this function processes the sort from the primeng
     * event and returns a functional order array to our api
     *
     * @param multiSortMeta
     * @param sortField
     * @param sortOrder
     * @returns Order[]
     */
    private sortProcessing;
    /**
     * this function receives the event from primeng and returns
     * the filtergroup with all the necessary information to be used by our api
     * @param event
     * @param globalFilterFields
     * @param globalFilterExpression
     * @returns FilterGroup
     */
    getFilterGroupByLazyLoadEvent(event: LazyLoadEvent, globalFilterFields?: string[], globalFilterExpression?: FilterExpressions): FilterGroup;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrimengUtilityService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<PrimengUtilityService>;
}
