import { FormGroup } from '@angular/forms';
import { BaseField } from '../../components/dynamic-form/models/base-field';
import * as i0 from "@angular/core";
/**
 * injectable
 */
export declare class FormGroupService {
    /**constructor */
    constructor();
    /**
     * this function is responsible for creating a formGroup[]
     * with the respective values and validations for each field of the object
     * @param objects
     * @param columnsData
     * @returns
     */
    toFormGroupMultipleObjects(objects: any[], columnsData: BaseField[]): FormGroup[];
    /**
     * this function is responsible for creating a formGroup
     * with the respective values and validations for a given object
     *
     * @param object
     * @param columnsData
     * @returns
     */
    toFormGroupOneObject(object: any, columnsData: BaseField[]): FormGroup;
    /**
     * this function returns an object with the
     * required fields with its formControl
     *
     * @param objectProperties
     * @param columnsData
     * @returns any
     */
    getFormGroup(objectProperties: string[], columnsData: BaseField[]): any;
    /**
     * this function recive fields and transform it in a form group
     * @param fields
     * @returns FormGroup
     */
    toFormGroup(fields: BaseField[]): FormGroup;
    static ɵfac: i0.ɵɵFactoryDeclaration<FormGroupService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<FormGroupService>;
}
