import { EventEmitter } from "@angular/core";
import { BehaviorSubject, Subscription } from "rxjs";
import { OwnerContext } from "../../models/owner-context.model";
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class ContextGenericService {
    /**
     * Map that holds all the variables and actions.
     * <br />-> key - owner name
     * <br />-> value object that holds a map for variables and a map for actions
     */
    protected context: Map<string, OwnerContext>;
    /**
     * Array that holds all subscriptions, used to clean up on destroy
     */
    protected subscriptions: Subscription[];
    /**
     * Clean up all
     */
    ngOnDestroy(): void;
    /**
     * Get owner context using name, if the context does not exist, it is created
     * @param ownerName Name of the owner
     * @returns The owner full context
     */
    protected getOwnerContext(ownerName: string): any;
    /**
     * Get a variable subject using owner and name, if the variable does not exist, it is created
     * @param ownerName Name of the owner
     * @param variableName Name of the variable
     * @returns Subject of the variable
     */
    protected getVariable(ownerName: string, variableName: string): BehaviorSubject<any>;
    /**
     * Subscribes to a variable subject using owner and name, if the variable does not exist, it is created
     * @param ownerName Name of the owner
     * @param variableName Name of the variable
     * @param callback callback function of the subscriber
     * @returns Susbcription
     */
    subscribeVariable(ownerName: string, variableName: string, callback: Function): Subscription;
    /**
     *  // TODO: This method should be changed to a generic utils class
     */
    protected cloneObject(obj: any): any;
    /**
     * Set data to a variable subject using owner and name, if the variable does not exist, it is created
     * @param ownerName Name of the owner
     * @param variableName Name of the variable
     * @param data Data to be set
     */
    setVariableData(ownerName: string, variableName: string, data: any): void;
    /**
     * Get an action event using owner and name, if the action does not exist, it is created
     * @param ownerName Name of the owner
     * @param actionName Name of the action
     * @returns Event of the action
     */
    protected getAction(ownerName: string, actionName: string): EventEmitter<any>;
    /**
     * Subscribes to an action using owner and name, if the variable does not exist, it is created
     * @param ownerName Name of the owner
     * @param actionName Name of the action
     * @param callback callback function of the subscriber
     * @returns Susbcription
     */
    subscribeAction(ownerName: string, actionName: string, callback: Function): Subscription;
    /**
     * Send action using owner and name, if the action does not exist, it is created
     * @param ownerName Name of the owner
     * @param actionName Name of the action
     * @param data Data to be set
     */
    sendAction(ownerName: string, actionName: string, data: any): void;
    /**
     * Unsubscribes a subscription
     * @param subscription Subscription to unsubscribe
     */
    unsubscribe(subscription: Subscription | Subscription[]): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ContextGenericService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ContextGenericService>;
}
