import { BehaviorSubject, Observable } from "rxjs";
import { ConfigurationItem } from "../../models/configuration-item.model";
/**
 * AbstractConfigurationItemsService class that defines an
 * <br />abstract configuration items service to
 * <br />be extended by the mock and real
 * <br />authentication services
 */
export declare abstract class AbstractConfigurationItemsService {
    /**
     * Current configurationItems
     */
    protected configurationItemsSubject: BehaviorSubject<ConfigurationItem[]>;
    /**
     * Gets the configuration items
     *
     * @returns Boolean promise, true when successful
     */
    abstract getConfigurationItemsAsync(): Promise<boolean>;
    /**
     * Setter for configurationItemsSubject
     *
     * @param {ConfigurationItem[]} value The ConfigurationItems array
     */
    protected setConfigurationItems(value: ConfigurationItem[]): void;
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject as an observable
     */
    getConfigurationItemsObservable(): Observable<ConfigurationItem[]>;
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject current value
     */
    getConfigurationItemsValue(): ConfigurationItem[];
}
