import { BehaviorSubject, Observable } from 'rxjs';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class BaseCacheService<T> {
    /**
     * map with a BehaviorSubject for each element
     */
    protected cacheMapSubject: Map<string, BehaviorSubject<T>>;
    /**
     * BehaviorSubject of a list of elements
     */
    protected cacheListSubject: BehaviorSubject<T[]>;
    /**
     * cache expiration time
     */
    protected cacheTimeMs: number;
    /**
     * saves the date the cache was updated
     */
    protected entityTypeGetDate: Date;
    /**
     *
     * @param values
     * @param key
     */
    protected setToCache(values: T[] | T, key?: string): void;
    /**
     * this function is responsible for managing the cache of each element
     * @param values
     * @param key
     */
    private setToCacheMap;
    /**
     * this function is responsible for managing the cache of a list of elements
     * @param values
     */
    private setToCacheList;
    /**
     * Getter for cache map element by key
     *
     * @returns The elmement as an observable
     */
    getElementObservableByKey(key: string): Observable<T>;
    /**
     * Getter for element value by key
     *
     * @returns Element current value
     */
    getElementByKey(key: string): T;
    /**
     * returns the observale of the list
     * @returns
     */
    getElementsListObservable(): Observable<T[]>;
    /**
     * returns the elements of the list
     * @returns
     */
    getElementsList(): T[];
    /**
     * return if cache is valid
     * @returns boolean
     */
    isCacheValid(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<BaseCacheService<any>, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<BaseCacheService<any>>;
}
